/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.ovopark.constants.LogConstant;
import com.ovopark.constants.MessageConstant;
import com.ovopark.mapper.InspectionTaskExpandMapper;
import com.ovopark.model.dto.ExpandCountDto;
import com.ovopark.model.enums.DefaultEnum;
import com.ovopark.model.enums.ExpandExecuteExpireEnum;
import com.ovopark.model.enums.InspectionPlanMainTypeEnum;
import com.ovopark.model.enums.InspectionTaskExpandStatusEnum;
import com.ovopark.model.enums.InspectionTaskStatusEnum;
import com.ovopark.model.enums.IsExecutorEnum;
import com.ovopark.model.enums.IsTodoMessageEnum;
import com.ovopark.model.enums.JumpTypeEnum;
import com.ovopark.model.enums.MainTypeEnum;
import com.ovopark.model.login.Users;
import com.ovopark.model.req.FixReq;
import com.ovopark.model.req.InsertReasonReq;
import com.ovopark.model.req.WebDetailReq;
import com.ovopark.model.resp.WebDetailResp;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.EnterpriseConfigPojo;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.po.InspectionTask;
import com.ovopark.po.InspectionTaskExpand;
import com.ovopark.po.IsInspectionDeptTemplate;
import com.ovopark.proxy.DepartProxy;
import com.ovopark.proxy.MessageProxy;
import com.ovopark.proxy.OrganizeProxy;
import com.ovopark.service.InspectionTaskExpandService;
import com.ovopark.service.InspectionTaskService;
import com.ovopark.service.IsInspectionDeptTemplateService;
import com.ovopark.service.UsersRemoteService;
import com.ovopark.utils.BigDecimalUtils;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.ListUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionTaskExpandServiceImpl
extends ServiceImpl<InspectionTaskExpandMapper, InspectionTaskExpand>
implements InspectionTaskExpandService {
    private static final Logger log = LoggerFactory.getLogger(InspectionTaskExpandServiceImpl.class);
    @Autowired
    private InspectionTaskExpandMapper inspectionTaskExpandMapper;
    @Autowired
    MessageProxy messageProxy;
    @Autowired
    private IsInspectionDeptTemplateService deptTemplateService;
    @Autowired
    private InspectionTaskService taskService;
    @Autowired
    private DepartProxy departProxy;
    @Autowired
    private UsersRemoteService usersRemoteService;
    @Autowired
    private EnterpriseGroupsApi enterpriseGroupsApi;
    @Autowired
    private OrganizeProxy organizeProxy;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void returnExpand(Integer expandId, Integer templateId, Integer operatorId, String templateName) {
        List expireExecutes;
        InspectionTaskExpand taskExpand;
        Date now = new Date();
        InspectionTaskExpand expand = (InspectionTaskExpand)this.getById(expandId);
        BaseResult result = this.enterpriseGroupsApi.getEnterpriseConfig(expand.getGroupId());
        DepartmentPojo department = this.departProxy.getDepartment(expand.getDeptId());
        Users users = this.usersRemoteService.getById(operatorId);
        this.taskService.insertLog(users, expand.getTaskId(), LogConstant.RETURN, users.getShowName(), department != null ? department.getName() : "", templateName);
        if (templateId != null) {
            IsInspectionDeptTemplate one = (IsInspectionDeptTemplate)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.deptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getTemplateId, (Object)templateId)).eq(IsInspectionDeptTemplate::getExpandId, (Object)expandId)).one();
            one.setIsRead(DefaultEnum.DEFAULT_FALSE.getCode());
            this.deptTemplateService.update(one);
        }
        if ((taskExpand = (InspectionTaskExpand)this.getById(expandId)).getStatus().equals(InspectionTaskExpandStatusEnum.WAIT.getCode())) {
            return;
        }
        InspectionTask task = (InspectionTask)this.taskService.getById(taskExpand.getTaskId());
        Integer executeExpire = ExpandExecuteExpireEnum.DEFAULT.getCode();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.deptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getExpandId, (Object)expandId)).eq(IsInspectionDeptTemplate::getIsRead, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List collect = list.stream().map(IsInspectionDeptTemplate::getUpdateTime).collect(Collectors.toList());
            Date maxDate = (Date)Collections.max(collect);
            executeExpire = maxDate.after(task.getEndTime()) ? ExpandExecuteExpireEnum.YES.getCode() : ExpandExecuteExpireEnum.NOT.getCode();
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(InspectionTaskExpand::getStatus, (Object)DefaultEnum.DEFAULT_FALSE.getCode())).set(InspectionTaskExpand::getFinishTime, null)).set(InspectionTaskExpand::getExecuteExpire, (Object)executeExpire)).eq(InspectionTaskExpand::getId, (Object)expandId)).update();
        Integer completeExpandCount = task.getCompleteExpandCount();
        boolean flag = task.getTotalExpandCount().equals(completeExpandCount);
        completeExpandCount = completeExpandCount > 0 ? Integer.valueOf(completeExpandCount - 1) : Integer.valueOf(0);
        BigDecimal percent = BigDecimalUtils.calculatePercent((Integer)completeExpandCount, (Integer)task.getTotalExpandCount(), (Integer)BigDecimalUtils.DEFAULT_SCALE_FOUR, (Integer)4);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.taskService.lambdaUpdate().eq(InspectionTask::getId, (Object)taskExpand.getTaskId())).set(InspectionTask::getCompleteExpandCount, (Object)completeExpandCount)).set(InspectionTask::getCompletePercent, (Object)percent)).set(InspectionTask::getStatus, (Object)(task.getStatus().equals(InspectionTaskStatusEnum.PASS.getCode()) ? InspectionTaskStatusEnum.PASS.getCode() : InspectionTaskStatusEnum.INSPECT.getCode()))).update();
        if (task.getEndTime().before(now) && result.getData() != null && StringUtils.isNotBlank((String)((EnterpriseConfigPojo)result.getData()).getExpireExecute()) && !(expireExecutes = Stream.of(((EnterpriseConfigPojo)result.getData()).getExpireExecute().split(",")).map(Integer::parseInt).collect(Collectors.toList())).contains(MainTypeEnum.INSPECTION.getCode())) {
            return;
        }
        if (flag) {
            this.messageProxy.sendWebSocketAndJpush(task.getOperatorId(), task.getAuditId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.RETURN_MESSAGE, task.getName()), task.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, task.getId(), InspectionPlanMainTypeEnum.INSPECTION, DefaultEnum.DEFAULT_TRUE.getCode(), JumpTypeEnum.DETAIL.getCode(), IsExecutorEnum.EXECUTOR.getCode(), IsTodoMessageEnum.IS_TODO_MESSAGE.getCode(), task.getEndTime());
        }
    }

    @Override
    public void fix(FixReq req) {
        List tasks = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.taskService.lambdaQuery().eq(InspectionTask::getGroupId, (Object)req.getGroupId())).between(InspectionTask::getEndTime, (Object)req.getStartTime(), (Object)req.getEndTime())).eq(InspectionTask::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode())).list();
        Map<Object, Object> taskMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)tasks)) {
            taskMap = tasks.stream().collect(Collectors.toMap(InspectionTask::getId, InspectionTask::getEndTime));
            List expands = ((LambdaQueryChainWrapper)this.lambdaQuery().in(InspectionTaskExpand::getTaskId, taskMap.keySet())).list();
            if (CollectionUtils.isNotEmpty((Collection)expands)) {
                Map<Object, Object> expandTemplateMap = new HashMap();
                List expandIds = expands.stream().map(InspectionTaskExpand::getId).collect(Collectors.toList());
                List deptTemplates = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.deptTemplateService.lambdaQuery().in(IsInspectionDeptTemplate::getExpandId, expandIds)).eq(IsInspectionDeptTemplate::getIsRead, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).list();
                if (CollectionUtils.isNotEmpty((Collection)deptTemplates)) {
                    expandTemplateMap = deptTemplates.stream().collect(Collectors.groupingBy(IsInspectionDeptTemplate::getExpandId, Collectors.collectingAndThen(Collectors.reducing((c1, c2) -> c1.getUpdateTime().after(c2.getUpdateTime()) ? c1 : c2), Optional::get)));
                }
                HashMap finalExpandTemplateMap = expandTemplateMap;
                Map<Object, Object> finalTaskMap = taskMap;
                ((Stream)expands.stream().parallel()).forEach(i -> {
                    IsInspectionDeptTemplate deptTemplate = (IsInspectionDeptTemplate)finalExpandTemplateMap.get(i.getId());
                    if (deptTemplate != null && deptTemplate.getUpdateTime().after((Date)finalTaskMap.get(i.getTaskId()))) {
                        i.setExecuteExpire(ExpandExecuteExpireEnum.YES.getCode());
                    }
                    if (deptTemplate != null && i.getStatus().equals(InspectionTaskExpandStatusEnum.PASS.getCode())) {
                        i.setFinishTime(deptTemplate.getUpdateTime());
                    }
                    if (deptTemplate == null && i.getStatus().equals(InspectionTaskExpandStatusEnum.PASS.getCode())) {
                        i.setFinishTime(i.getUpdateTime());
                    }
                    if (deptTemplate == null && i.getStatus().equals(InspectionTaskExpandStatusEnum.WAIT.getCode())) {
                        i.setExecuteExpire(ExpandExecuteExpireEnum.DEFAULT.getCode());
                    }
                });
                expands.forEach(System.out::println);
                this.saveOrUpdateBatch(expands);
            }
        }
    }

    @Override
    public List<ExpandCountDto> countFinish(List<Integer> taskIds) {
        return this.inspectionTaskExpandMapper.countFinish(taskIds);
    }

    @Override
    public boolean deletedDepFix(Users users, Integer teskId) {
        InspectionTask task = (InspectionTask)this.taskService.getById(teskId);
        if (task.getAuditId().equals(users.getId()) && !task.getOperatorId().equals(users.getId())) {
            log.info("\u5ba1\u6838\u4eba\u4e0d\u8fdb\u884c\u72b6\u6001\u53d8\u66f4");
            return false;
        }
        List inspectionTaskExpands = this.inspectionTaskExpandMapper.selectExpandListByTaskId(teskId, users.getGroupId());
        Integer finishCount = 0;
        Integer unfinishCount = 0;
        List<Integer> deletedDepIds = this.departProxy.getDeletedDepIds(users.getGroupId());
        for (InspectionTaskExpand expand : inspectionTaskExpands) {
            finishCount = finishCount + (InspectionTaskExpandStatusEnum.PASS.getCode().equals(expand.getStatus()) ? 1 : 0);
            if (!InspectionTaskExpandStatusEnum.WAIT.getCode().equals(expand.getStatus())) continue;
            if (CollectionUtils.isNotEmpty(deletedDepIds)) {
                unfinishCount = unfinishCount + (!deletedDepIds.contains(expand.getDeptId()) ? 1 : 0);
                continue;
            }
            unfinishCount = unfinishCount + 1;
        }
        log.info("\u5df2\u5b8c\u6210\u7684\u4efb\u52a1\u6570\uff1a{},\u672a\u5b8c\u6210\u6570\uff1a{}", (Object)finishCount, (Object)unfinishCount);
        if (unfinishCount > 0) {
            return false;
        }
        boolean update = ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.taskService.lambdaUpdate().eq(InspectionTask::getId, (Object)teskId)).set(InspectionTask::getStatus, (Object)(finishCount == 0 ? InspectionTaskStatusEnum.INVALID.getCode() : InspectionTaskStatusEnum.FINISH.getCode()))).update();
        return update;
    }

    @Override
    public Page<WebDetailResp> webDetails(WebDetailReq req, Users user) {
        Page page = (Page)this.inspectionTaskExpandMapper.selectJoinPage((IPage)new Page((long)req.getPage().intValue(), (long)req.getPageSize().intValue()), WebDetailResp.class, (MPJBaseJoin)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper().selectAs(InspectionTask::getCreateTime, WebDetailResp::getCreateTime)).selectAs(InspectionTask::getName, WebDetailResp::getTaskName)).selectAs(InspectionTaskExpand::getExpectTime, WebDetailResp::getExpectTime)).selectAs(InspectionTaskExpand::getFinishTime, WebDetailResp::getFinishTime)).selectAs(InspectionTaskExpand::getExecuteExpire, WebDetailResp::getExecuteExpire)).selectAs(InspectionTaskExpand::getOperatorId, WebDetailResp::getOperatorId)).selectAs(InspectionTaskExpand::getDeptId, WebDetailResp::getDepId)).selectAs(InspectionTaskExpand::getStatus, WebDetailResp::getStatus)).selectAs(InspectionTaskExpand::getMainType, WebDetailResp::getMainType)).innerJoin(InspectionTask.class, InspectionTask::getId, InspectionTaskExpand::getTaskId)).in(CollectionUtils.isNotEmpty((Collection)req.getTaskIds()), InspectionTaskExpand::getTaskId, (Collection)req.getTaskIds())).eq(InspectionTask::getGroupId, (Object)user.getGroupId())).in(CollectionUtils.isNotEmpty((Collection)req.getOperatorIds()), InspectionTaskExpand::getOperatorId, (Collection)req.getOperatorIds())).between(req.getStartTime() != null && req.getEndTime() != null, InspectionTask::getStartTime, (Object)req.getStartTime(), (Object)req.getEndTime())).between(req.getStartTime() != null && req.getEndTime() != null, InspectionTask::getEndTime, (Object)req.getStartTime(), (Object)req.getEndTime())).between(req.getCreateStartTime() != null && req.getCreateEndTime() != null, InspectionTask::getCreateTime, (Object)req.getCreateStartTime(), (Object)req.getCreateEndTime())).isNotNull(req.getExpectStartTime() != null && req.getExpectEndTime() != null, InspectionTaskExpand::getExpectTime)).between(req.getExpectStartTime() != null && req.getExpectEndTime() != null, InspectionTaskExpand::getExpectTime, (Object)req.getExpectStartTime(), (Object)req.getExpectEndTime())).between(req.getFinishStartTime() != null && req.getFinishEndTime() != null, InspectionTaskExpand::getFinishTime, (Object)req.getFinishStartTime(), (Object)req.getFinishEndTime())).eq(req.getExecuteExpire() != null, InspectionTaskExpand::getExecuteExpire, (Object)req.getExecuteExpire())).eq(req.getStatus() != null, InspectionTaskExpand::getStatus, (Object)req.getStatus())).eq(InspectionTaskExpand::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode())).eq(InspectionTaskExpand::getGroupId, (Object)user.getGroupId())).eq(req.getMainType() != null, InspectionTaskExpand::getMainType, (Object)req.getMainType())).last(req.getFinishInTime() != null && req.getFinishInTime() == 1, "and t.finish_time is not null and t.expect_time is not null   and DATE(t.expect_time) >= DATE(t.finish_time) order by t1.create_time desc, t1.id asc")).last(req.getFinishInTime() != null && req.getFinishInTime() == 0, "and t.finish_time is not null and t.expect_time is not null   and DATE(t.finish_time) > DATE(t.expect_time) order by t1.create_time desc, t1.id asc")).last(req.getFinishInTime() == null, "order by t1.create_time desc, t1.id asc"));
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            ArrayList<Integer> depIds = new ArrayList<Integer>();
            ArrayList<Integer> operatorIds = new ArrayList<Integer>();
            for (WebDetailResp record : page.getRecords()) {
                depIds.add(record.getDepId());
                operatorIds.add(record.getOperatorId());
            }
            Map<Integer, String> userNameMap = this.usersRemoteService.getCoreUserNameMapByIds(operatorIds);
            Map<Integer, DepartmentPojo> depName = this.departProxy.getDepartments(depIds);
            Map<Integer, List<String>> orgMap = this.organizeProxy.selectOrganizeMap(operatorIds, user.getGroupId());
            Map<Integer, String> userParentMap = this.usersRemoteService.getParentUsersByUserIds(operatorIds, user.getGroupId());
            Map<Integer, String> userRoleMap = this.usersRemoteService.getIdAndNameByRoleId(operatorIds, user.getGroupId());
            for (WebDetailResp record : page.getRecords()) {
                if (depName.get(record.getDepId()) != null) {
                    record.setDepName(depName.get(record.getDepId()).getName());
                    record.setShopId(depName.get(record.getDepId()).getShopId());
                }
                record.setOperatorName(userNameMap.get(record.getOperatorId()));
                record.setOperatorParentName(userParentMap.get(record.getOperatorId()));
                record.setOperatorRole(userRoleMap.get(record.getOperatorId()));
                record.setOrgName(ListUtils.listStrToString(orgMap.get(record.getOperatorId())));
                if (record.getExpectTime() == null || record.getFinishTime() == null) continue;
                record.setFinishInTime(Integer.valueOf(DateUtils.getStartTimeOfDay((Date)record.getExpectTime()).compareTo(DateUtils.getStartTimeOfDay((Date)record.getFinishTime())) != -1 ? 1 : 0));
            }
        }
        return page;
    }

    @Override
    public Boolean insertReason(InsertReasonReq req) {
        InspectionTaskExpand expand = (InspectionTaskExpand)this.getById(req.getExpandId());
        if (expand == null) {
            return false;
        }
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(InspectionTaskExpand::getId, (Object)req.getExpandId())).set(InspectionTaskExpand::getReason, (Object)req.getReason())).update();
    }

    @Override
    public Map<String, Object> getReason(InsertReasonReq req) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        InspectionTaskExpand expand = (InspectionTaskExpand)this.getById(req.getExpandId());
        if (expand == null) {
            return map;
        }
        map.put("expandId", expand.getId());
        map.put("reason", expand.getReason());
        return map;
    }
}

