/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.alibaba.fastjson.JSON;
import com.ovopark.enums.NotificationTypeEnum;
import com.ovopark.messagehub.sdk.MessageHubV2Api;
import com.ovopark.messagehub.sdk.model.MessageRequest;
import com.ovopark.messagehub.sdk.model.ParamContext;
import com.ovopark.messagehub.sdk.model.SubsBuilders;
import com.ovopark.messagehub.sdk.model.ThirdMessage;
import com.ovopark.model.dto.message.BaseMessageDTO;
import com.ovopark.model.dto.message.ThirdMessageDTO;
import com.ovopark.service.Impl.AbstractNotificationSender;
import java.util.Arrays;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DingTalkNotificationSenderImpl
extends AbstractNotificationSender {
    private static final Logger log = LoggerFactory.getLogger(DingTalkNotificationSenderImpl.class);

    protected DingTalkNotificationSenderImpl(MessageHubV2Api messageHubV2Api) {
        super(messageHubV2Api);
    }

    @Override
    protected NotificationTypeEnum getType() {
        return NotificationTypeEnum.DINGTALK;
    }

    @Override
    public void sendNotification(BaseMessageDTO baseMessageDTO) {
        log.info("Start sending notification for message by JPush: {}", (Object)baseMessageDTO);
        try {
            this.validate(baseMessageDTO);
            MessageRequest message = this.buildMessage(baseMessageDTO);
            log.info("MessageRequest built successfully : {}", (Object)message);
            super.preSendLog(baseMessageDTO, JSON.toJSONString((Object)baseMessageDTO));
            super.doSend(message);
            log.info("Message sent successfully for message DTO:{} with MessageRequest: {}", (Object)JSON.toJSONString((Object)baseMessageDTO), (Object)JSON.toJSONString((Object)message));
            super.postSendLog(baseMessageDTO, JSON.toJSONString((Object)baseMessageDTO));
            this.handleResult(baseMessageDTO);
        }
        catch (Exception e) {
            log.error("Error sending notification", (Throwable)e);
        }
    }

    @Override
    public boolean supports(BaseMessageDTO baseMessageDTO) {
        return false;
    }

    @Override
    protected void validate(BaseMessageDTO request) {
        log.info("Validating DingTalk request: {}", (Object)JSON.toJSONString((Object)request));
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
    }

    @Override
    protected <T> MessageRequest buildMessage(T t) {
        if (!(t instanceof ThirdMessageDTO)) {
            throw new IllegalArgumentException("t is not instance of DingTalkMessageDTO");
        }
        log.info("Start building MessageRequest for object: {}", t);
        ThirdMessageDTO thirdMessageDTO = (ThirdMessageDTO)t;
        ThirdMessage thirdMessage = new ThirdMessage();
        thirdMessage.setEnterpriseId(Integer.valueOf(1084));
        thirdMessage.setObjectId(Integer.valueOf(123456));
        MessageRequest messageRequest = ((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)((SubsBuilders.ThirdBuilder)SubsBuilders.third((String)"Device_Alert_Notify").from("test")).toUserIdList(thirdMessageDTO.getUserIdList())).locale(Locale.CHINA)).tagList(Arrays.asList("test", "offline"))).overrideToUserIdList(thirdMessageDTO.getUserIdList().subList(0, 7)).thirdMessage(thirdMessage).mcTitle(new ParamContext().plainText("\u6389\u7ebf\u63d0\u9192"))).build();
        return messageRequest;
    }

    @Override
    protected void handleResult(BaseMessageDTO request) {
        log.info("Handling result for ThirdMessage request: {}", (Object)JSON.toJSONString((Object)request));
    }
}

