/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.alibaba.fastjson.JSON;
import com.ovopark.enums.NotificationTypeEnum;
import com.ovopark.messagehub.sdk.MessageHubV2Api;
import com.ovopark.messagehub.sdk.model.MCRequest;
import com.ovopark.messagehub.sdk.model.MCRequestBuilders;
import com.ovopark.messagehub.sdk.model.MessageRequest;
import com.ovopark.messagehub.sdk.model.ParamContext;
import com.ovopark.model.dto.message.BaseMessageDTO;
import com.ovopark.model.dto.message.MCMessageDTO;
import com.ovopark.service.Impl.AbstractNotificationSender;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MCMessageServiceImpl
extends AbstractNotificationSender {
    private static final Logger log = LoggerFactory.getLogger(MCMessageServiceImpl.class);

    protected MCMessageServiceImpl(MessageHubV2Api messageHubV2Api) {
        super(messageHubV2Api);
    }

    @Override
    protected NotificationTypeEnum getType() {
        return NotificationTypeEnum.MC;
    }

    @Override
    public void sendNotification(BaseMessageDTO baseMessageDTO) {
        log.info("Start sending notification for message by MC: {}", (Object)baseMessageDTO);
        try {
            this.validate(baseMessageDTO);
            MCRequest message = this.buildMCMessage(baseMessageDTO);
            log.info("MCRequest built successfully : {}", (Object)message);
            super.preSendLog(baseMessageDTO, JSON.toJSONString((Object)baseMessageDTO));
            super.sendMCMessage(message, false, 100);
            log.info("Message sent successfully for message DTO:{} with MCRequest: {}", (Object)JSON.toJSONString((Object)baseMessageDTO), (Object)JSON.toJSONString((Object)message));
            super.postSendLog(baseMessageDTO, JSON.toJSONString((Object)baseMessageDTO));
            this.handleResult(baseMessageDTO);
        }
        catch (Exception e) {
            log.error("Error sending notification", (Throwable)e);
        }
    }

    @Override
    public boolean supports(BaseMessageDTO baseMessageDTO) {
        return baseMessageDTO instanceof MCMessageDTO;
    }

    @Override
    protected void validate(BaseMessageDTO request) {
        log.info("Validating MCMessage request: {}", (Object)JSON.toJSONString((Object)request));
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
    }

    @Override
    protected <T> MCRequest buildMCMessage(T t) {
        log.info("Start building MCRequest for object: {}", t);
        MCRequest mcRequest = new MCRequest();
        MCMessageDTO mcMessageDTO = (MCMessageDTO)t;
        MCRequestBuilders builder = (MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)MCRequestBuilders.mcRequest((String)mcMessageDTO.getObjectType()).toUserIdList(Arrays.asList(mcMessageDTO.getTargetUserId())).sendUserId(Long.valueOf(mcMessageDTO.getUserId().intValue()))).mcCategory(mcMessageDTO.getCategory())).mcObjectType(mcMessageDTO.getObjectType())).mcSubId(Long.valueOf(mcMessageDTO.getRelatedId().intValue()))).mcTitle(new ParamContext().plainText(mcMessageDTO.getTitle()))).mcContent(new ParamContext().plainText(mcMessageDTO.getContent()))).mcDescription(JSON.toJSONString(this.combineMap(mcMessageDTO)))).mcHidden(false)).locale(Locale.CHINA);
        if (mcMessageDTO.getJumpType() != null) {
            builder.mcObjectId(Long.valueOf(mcMessageDTO.getJumpType().intValue()));
        }
        MessageRequest messageRequest = builder.build();
        mcRequest.add(messageRequest);
        log.info("MCRequest built successfully: {}", (Object)JSON.toJSONString((Object)mcRequest));
        return mcRequest;
    }

    private Map<String, Object> combineMap(MCMessageDTO mcMessageDTO) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (mcMessageDTO.getType() != null) {
            param.put("type", mcMessageDTO.getType());
        }
        if (mcMessageDTO.getRelatedId() != null) {
            param.put("taskId", mcMessageDTO.getRelatedId());
        }
        return param;
    }

    @Override
    protected void handleResult(BaseMessageDTO request) {
        log.info("Handling result for MCMessage request: {}", (Object)JSON.toJSONString((Object)request));
    }
}

