/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.alibaba.fastjson.JSON;
import com.ovopark.messagehub.sdk.TodoMessageV2Api;
import com.ovopark.messagehub.sdk.model.OneTodoMessageBulkSaveRequest;
import com.ovopark.messagehub.sdk.model.OneTodoMessageSaveRequest;
import com.ovopark.messagehub.sdk.model.TodoMessageBulkSaveResponse;
import com.ovopark.messagehub.sdk.model.TodoMessageSaveRequest;
import com.ovopark.messagehub.sdk.model.TodoMessageSaveResponse;
import com.ovopark.model.dto.message.BaseMessageDTO;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.service.Impl.CompositeMessageAssembler;
import com.ovopark.service.TodoService;
import com.ovopark.utils.ListUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TodoServiceImpl
implements TodoService {
    private static final Logger log = LoggerFactory.getLogger(TodoServiceImpl.class);
    private final TodoMessageV2Api todoMessageV2Api;
    private final CompositeMessageAssembler compositeMessageAssembler;

    public TodoServiceImpl(TodoMessageV2Api todoMessageV2Api, CompositeMessageAssembler compositeMessageAssembler) {
        this.todoMessageV2Api = todoMessageV2Api;
        this.compositeMessageAssembler = compositeMessageAssembler;
    }

    @Override
    public Boolean saveTodo(List<BaseMessageDTO> baseMessageDTOs) {
        Boolean result = false;
        log.info("Starting saveTodo for baseMessageDTOs: {}", baseMessageDTOs);
        try {
            TodoMessageSaveRequest todoMessageSaveRequest = this.compositeMessageAssembler.assembleMessageRequest(baseMessageDTOs, false, TodoMessageSaveRequest.class);
            log.info("Assembled TodoMessageSaveRequest: {}", (Object)JSON.toJSONString((Object)todoMessageSaveRequest));
            log.info("Calling third-party API saveTodoMessage with request: {}", (Object)JSON.toJSONString((Object)todoMessageSaveRequest));
            BaseResult baseResult = this.todoMessageV2Api.saveTodoMessage(OneTodoMessageSaveRequest.from((TodoMessageSaveRequest)todoMessageSaveRequest));
            log.info("Received response from third-party API: {}", (Object)JSON.toJSONString((Object)baseResult));
            if (baseResult != null && !baseResult.getIsError().booleanValue()) {
                TodoMessageSaveResponse todoMessageSaveResponse = (TodoMessageSaveResponse)baseResult.getData();
                TodoMessageSaveResponse.IDResult idResult = todoMessageSaveResponse.getIdResult();
                for (Map.Entry entry : idResult.getSuccess().entrySet()) {
                    log.info("Save success, user id: {}, todo msg id: {}", entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : idResult.getFail().entrySet()) {
                    log.warn("Save fail, user id: {}", entry.getKey());
                }
                result = true;
            } else {
                log.warn("Third-party API returned an error or null result.");
            }
        }
        catch (Exception e) {
            log.error("Exception occurred while calling third-party API saveTodoMessage", (Throwable)e);
        }
        log.info("Finished saveTodo with result: {}", (Object)result);
        return result;
    }

    @Override
    public Boolean bulkSaveTodo(List<BaseMessageDTO> baseMessageDTOs) {
        Boolean result = false;
        log.info("bulkSaveTodo input baseMessageDTOs: {}", (Object)JSON.toJSONString(baseMessageDTOs));
        List saveRequests = this.compositeMessageAssembler.assembleMessageRequest(baseMessageDTOs, true, List.class);
        log.info("Assembled saveRequests: {}", (Object)JSON.toJSONString((Object)saveRequests));
        List partitions = ListUtils.partition((List)saveRequests, (int)100);
        log.info("Partitioned saveRequests into {} parts", (Object)partitions.size());
        for (List partition : partitions) {
            log.info("Processing partition with size: {}", (Object)partition.size());
            OneTodoMessageBulkSaveRequest bulkSaveRequest = new OneTodoMessageBulkSaveRequest();
            ArrayList<OneTodoMessageSaveRequest> oneTodoMessageSaveRequestList = new ArrayList<OneTodoMessageSaveRequest>();
            OneTodoMessageSaveRequest oneTodoMessageSaveRequest = new OneTodoMessageSaveRequest();
            oneTodoMessageSaveRequest.setTodoMessageSaveRequestList(partition);
            oneTodoMessageSaveRequestList.add(oneTodoMessageSaveRequest);
            bulkSaveRequest.setOneTodoMessageSaveRequestList(oneTodoMessageSaveRequestList);
            log.info("bulkSaveRequest: {}", (Object)JSON.toJSONString((Object)bulkSaveRequest));
            BaseResult baseResult = this.todoMessageV2Api.bulkSaveTodoMessage(bulkSaveRequest);
            if (baseResult != null) {
                log.info("API response: {}", (Object)JSON.toJSONString((Object)baseResult));
            } else {
                log.error("API response is null");
            }
            if (baseResult != null && !baseResult.getIsError().booleanValue()) {
                TodoMessageBulkSaveResponse todoMessageBulkSaveResponse = (TodoMessageBulkSaveResponse)baseResult.getData();
                log.info("Bulk save response: {}", (Object)JSON.toJSONString((Object)todoMessageBulkSaveResponse));
                List idResult = todoMessageBulkSaveResponse.getIdResultList();
                for (TodoMessageSaveResponse.IDResult result1 : idResult) {
                    for (Map.Entry entry : result1.getSuccess().entrySet()) {
                        log.info("Success, user id: {}, todo msg id: {}", entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry entry : result1.getFail().entrySet()) {
                        log.warn("Fail, user id: {}", entry.getKey());
                    }
                }
                result = true;
                continue;
            }
            log.error("Bulk save failed or error occurred");
        }
        return result;
    }
}

