/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.proxy;

import com.alibaba.fastjson.JSON;
import com.ovopark.context.HttpContext;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.model.resp.organize.OrganzieUserResp;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.SimpleSuperUserMo;
import com.ovopark.organize.sdk.api.DepartmentTagApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.utils.OkHttp3Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class OrganizeProxy {
    private static final Logger log = LoggerFactory.getLogger(OrganizeProxy.class);
    @Autowired
    private DepartmentTagApi departmentTagApi;
    @Value(value="${organize.url}")
    private String organizeUrl;
    @Autowired
    private UserOrganizeApi userOrganizeApi;

    public List<Integer> getOrganzieUserIdList(List<Integer> organizeIdList, Integer groupId, Integer tokenType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupId", groupId);
        map.put("organizedIds", organizeIdList);
        log.info("\u8bf7\u6c42\u7ec4\u7ec7\u67b6\u6784:" + JSON.toJSONString(map) + "tokenType" + tokenType + "token\u503c" + HttpContext.getContextInfoToken());
        String result = OkHttp3Util.doPost((String)this.organizeUrl, map, (String)HttpContext.getContextInfoToken(), (Integer)tokenType);
        if (result == null) {
            throw new SysErrorException(ResultCode.ORGANZIE_PROXY_ERROR, new Object[0]);
        }
        OrganzieUserResp organzieUserResp = (OrganzieUserResp)JSON.parseObject((String)result, OrganzieUserResp.class);
        if (organzieUserResp == null || organzieUserResp.isError()) {
            throw new SysErrorException(ResultCode.ORGANZIE_PROXY_ERROR, new Object[0]);
        }
        List userIdList = organzieUserResp.getData();
        if (CollectionUtils.isEmpty((Collection)userIdList)) {
            return new ArrayList<Integer>();
        }
        return userIdList;
    }

    public Map<Integer, String> getUserOrganizeFirstByUserIds(Integer groupId, List<Integer> userIds) {
        SimpleSuperUserMo mo = new SimpleSuperUserMo();
        mo.setUserList(userIds);
        mo.setGroupId(groupId);
        BaseResult result = this.userOrganizeApi.getUserOrganizeMergeByUserIds(mo);
        log.info("\u7528\u6237\u7ec4\u7ec7\u67b6\u6784\u8bf7\u6c42\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)result));
        return result.getData() != null ? (Map)result.getData() : new HashMap();
    }

    public Map<Integer, List<String>> selectOrganizeMap(List<Integer> userIds, Integer groupId) {
        Map<Integer, List<String>> pojoMap = new HashMap<Integer, List<String>>();
        if (!CollectionUtils.isEmpty(userIds)) {
            BaseResult base = this.userOrganizeApi.getUserOrganizeFirstByUserIds(groupId, userIds, null);
            log.info("\u7528\u6237\u7ec4\u7ec7\u67b6\u6784\u8bf7\u6c42\u8fd4\u56de\uff1a{},{}", (Object)base.getIsError(), (Object)base.getRequestId());
            if (base != null && !StringUtils.isEmpty((Object)base.getData())) {
                pojoMap = (Map)base.getData();
            }
        }
        return pojoMap;
    }
}

