/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.ovopark.model.cache.CachedInspectionInfo;
import com.ovopark.service.InspectionLastTimeCacheService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Service;

@Service
public class InspectionLastTimeCacheServiceImpl
implements InspectionLastTimeCacheService {
    private static final Logger log = LoggerFactory.getLogger(InspectionLastTimeCacheServiceImpl.class);
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    @CachePut(value={"inspectionCache"}, key="#storeId + '_' + #templateId")
    public CachedInspectionInfo updateCache(String storeId, String templateId, CachedInspectionInfo cachedInspectionInfo) {
        log.info("Updating cache for key: " + storeId + '_' + templateId);
        return cachedInspectionInfo;
    }

    @Override
    @Cacheable(value={"inspectionCache"}, key="#cacheKey")
    public CachedInspectionInfo getFromCache(String cacheKey) {
        log.info("Cache miss, fetching data from external source for key: {}" + cacheKey);
        return null;
    }

    @Override
    @CacheEvict(value={"inspectionCache"}, key="#storeId + '_' + #templateId")
    public void clearCache(String storeId, String templateId) {
        log.info("Clearing cache for key: " + storeId + '_' + templateId);
    }

    @Override
    @CacheEvict(value={"inspectionCache"}, allEntries=true)
    public void clearAllCache() {
    }

    @Override
    public Object getCacheData(Long storeId, Long templateId) {
        Cache.ValueWrapper valueWrapper;
        Cache cache = this.cacheManager.getCache("inspectionCache");
        if (cache != null && (valueWrapper = cache.get((Object)(storeId + "_" + templateId))) != null) {
            return valueWrapper.get();
        }
        return null;
    }

    @Override
    public Set<String> getAllKeysFromCache(String cachePrefix) {
        return this.redisTemplate.keys((Object)(cachePrefix + "*"));
    }

    @Override
    public Set<String> getAllKeysFromCache() {
        HashSet<String> keys = new HashSet<String>();
        this.redisTemplate.execute(connection -> {
            ScanOptions options = ScanOptions.scanOptions().count(1000L).build();
            Cursor cursor = connection.scan(options);
            while (cursor.hasNext()) {
                keys.add(new String((byte[])cursor.next()));
            }
            return keys;
        });
        return keys;
    }

    @Override
    public Map<String, Object> getAllEntriesFromCache(String cachePrefix) {
        Set keys = this.redisTemplate.keys((Object)(cachePrefix + "*"));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (keys != null) {
            for (String key : keys) {
                Object value = this.redisTemplate.opsForValue().get((Object)key);
                resultMap.put(key, value);
            }
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> getAllEntriesFromCache() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        this.redisTemplate.execute(connection -> {
            ScanOptions options = ScanOptions.scanOptions().count(1000L).build();
            Cursor cursor = connection.scan(options);
            while (cursor.hasNext()) {
                String key = new String((byte[])cursor.next());
                Object value = this.redisTemplate.opsForValue().get((Object)key);
                resultMap.put(key, value);
            }
            return null;
        });
        return resultMap;
    }
}

