/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.model.proxy.OssResult;
import com.ovopark.model.proxy.OssUploadMo;
import com.ovopark.model.resp.JsonNewResult;
import com.ovopark.service.OssService;
import com.ovopark.utils.HttpUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OssServiceImpl
implements OssService {
    private static final Logger log = LoggerFactory.getLogger(OssServiceImpl.class);
    @Value(value="${ossUrl}")
    private String ossUrl;

    @Override
    public String uploadBase64(OssUploadMo mo) throws IOException {
        JsonNewResult object;
        String result = HttpUtils.sendJsonToOtherServer((String)(this.ossUrl + "/api/dc/storage/standard/base64/upload"), (Object)mo);
        if (StringUtils.isNotBlank((String)result) && (object = (JsonNewResult)JSONObject.parseObject((String)result, JsonNewResult.class)).getData() != null) {
            OssResult model = (OssResult)JSON.parseObject((String)JSON.toJSONString((Object)object.getData()), OssResult.class);
            return model.getOssUrl();
        }
        return null;
    }

    @Override
    public String uploadFile(OssUploadMo mo, File file) throws IOException {
        JsonNewResult object;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessCode", mo.getBusinessCode());
        map.put("enterprisePath", mo.getEnterprisePath());
        HttpResponse execute = ((HttpRequest)HttpRequest.post((String)(this.ossUrl + "/api/dc/storage/standard/upload")).header("Content-Type", "multipart/form-data")).form("businessCode", (Object)mo.getBusinessCode()).form("enterprisePath", (Object)mo.getEnterprisePath()).form("file", file).execute();
        if (execute.getStatus() == 200 && (object = (JsonNewResult)JSONObject.parseObject((String)execute.body(), JsonNewResult.class)).getData() != null) {
            try {
                OssResult model = (OssResult)JSON.parseObject((String)JSON.toJSONString((Object)object.getData()), OssResult.class);
                log.info("\u4e0a\u4f20\u8fd4\u56de\uff1a{}", (Object)model.getOssUrl());
                return model.getOssUrl();
            }
            catch (Exception e) {
                log.error("\u4e0a\u4f20\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        }
        return null;
    }
}

