/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.config.redis;

import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RQueue;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedDelayedQueue {
    private static final Logger log = LoggerFactory.getLogger(DistributedDelayedQueue.class);
    private final RedissonClient redissonClient;

    public DistributedDelayedQueue(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    public <T> void addDelayedTask(T t, long delay, TimeUnit timeUnit, String queueName) {
        if (delay < 0L) {
            delay = 0L;
        }
        RBlockingQueue blockingFairQueue = this.redissonClient.getBlockingQueue(queueName);
        RDelayedQueue delayedQueue = this.redissonClient.getDelayedQueue((RQueue)blockingFairQueue);
        delayedQueue.offer(t, delay, timeUnit);
    }

    public <T> void addDelayedTask(T t, long delay, TimeUnit timeUnit, Class<?> clazz) {
        this.addDelayedTask(t, delay, timeUnit, clazz.getName());
    }

    public <T> void addDelayedTask(T t, Date dest, Class<?> clazz) {
        log.info("addDelayedTask:{},dest:{},data:{}", new Object[]{clazz.getName(), dest, t});
        long delay = dest.getTime() - System.currentTimeMillis();
        this.addDelayedTask(t, delay, TimeUnit.MILLISECONDS, clazz);
    }

    public <T> void removeDelayedTask(T t, Class<?> clazz) {
        log.info("removeDelayedTask:{},data:{}", (Object)clazz.getName(), t);
        RBlockingQueue blockingFairQueue = this.redissonClient.getBlockingQueue(clazz.getName());
        RDelayedQueue delayedQueue = this.redissonClient.getDelayedQueue((RQueue)blockingFairQueue);
        try {
            delayedQueue.remove(t);
        }
        catch (Exception e) {
            log.error("delete plan [{}] error:", t, (Object)e);
        }
    }

    public <T> void removeAllDelayedTask(Collection<T> collections, Class<?> clazz) {
        log.debug("removeAllDelayedTask:{},data:{}", (Object)clazz.getName(), collections);
        RBlockingQueue blockingFairQueue = this.redissonClient.getBlockingQueue(clazz.getName());
        RDelayedQueue delayedQueue = this.redissonClient.getDelayedQueue((RQueue)blockingFairQueue);
        try {
            delayedQueue.removeAll(collections);
        }
        catch (Exception e) {
            log.error("delete plan [{}] error:", collections, (Object)e);
        }
    }
}

