/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.config.redis;

import com.ovopark.config.redis.DistributedDelayedQueue;
import com.ovopark.config.redis.DistributedDelayedQueueInit;
import com.ovopark.config.redis.DistributedDelayedQueueListener;
import java.util.List;
import org.redisson.api.RedissonClient;
import org.redisson.spring.starter.RedissonAutoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@AutoConfigureAfter(value={RedisAutoConfiguration.class, RedissonAutoConfiguration.class})
public class DistributedDelayedQueueAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DistributedDelayedQueueAutoConfiguration.class);
    private final RedissonClient redissonClient;
    private final RedisTemplate redisTemplate;

    @Bean
    public DistributedDelayedQueue distributedDelayedQueue() {
        return new DistributedDelayedQueue(this.redissonClient);
    }

    @Bean
    @ConditionalOnBean(value={DistributedDelayedQueue.class})
    public DistributedDelayedQueueInit distributedDelayedQueueInit(List<DistributedDelayedQueueListener<?>> listeners) {
        log.info("\u5ef6\u65f6\u961f\u5217\u521d\u59cb\u5316listeners:{}", listeners);
        return new DistributedDelayedQueueInit(listeners, this.redissonClient, this.redisTemplate);
    }

    public DistributedDelayedQueueAutoConfiguration(RedissonClient redissonClient, RedisTemplate redisTemplate) {
        this.redissonClient = redissonClient;
        this.redisTemplate = redisTemplate;
    }
}

