/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.delayqueue;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ovopark.constants.LogConstant;
import com.ovopark.constants.MessageConstant;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.mapper.InspectionTaskMapper;
import com.ovopark.model.dto.TaskAndAuditDto;
import com.ovopark.model.enums.DefaultEnum;
import com.ovopark.model.enums.ExpireStatusEnum;
import com.ovopark.model.enums.InspectionPlanMainTypeEnum;
import com.ovopark.model.enums.InspectionTaskExpandStatusEnum;
import com.ovopark.model.enums.InspectionTaskStatusEnum;
import com.ovopark.model.enums.IsExecutorEnum;
import com.ovopark.model.enums.IsTodoMessageEnum;
import com.ovopark.model.enums.JumpTypeEnum;
import com.ovopark.model.enums.MainTypeEnum;
import com.ovopark.model.enums.MessageObjectEnum;
import com.ovopark.model.enums.OperatorActionEnum;
import com.ovopark.model.enums.OperatorTypeEnum;
import com.ovopark.model.enums.ThreadNamePrefixEnum;
import com.ovopark.model.enums.YesEnum;
import com.ovopark.model.login.Users;
import com.ovopark.po.DeleteMessagesByObject;
import com.ovopark.po.DeleteMessagesByObjectBuilder;
import com.ovopark.po.InspectionAuditConfigFirstVersionModel;
import com.ovopark.po.InspectionTask;
import com.ovopark.po.InspectionTaskExpand;
import com.ovopark.proxy.MessageProxy;
import com.ovopark.service.EnterpriseConfigService;
import com.ovopark.service.InspectionTaskExpandService;
import com.ovopark.service.InspectionTaskService;
import com.ovopark.service.UsersRemoteService;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.RedisDelayedTaskUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DelayedTasksListener {
    private static final Logger log = LoggerFactory.getLogger(DelayedTasksListener.class);
    @Autowired
    private InspectionTaskMapper inspectionTaskMapper;
    @Autowired
    private InspectionTaskService inspectionTaskService;
    @Autowired
    MessageProxy messageProxy;
    @Autowired
    private RedisDelayedTaskUtil delayedTaskUtil;
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private UsersRemoteService usersRemoteService;
    @Autowired
    private EnterpriseConfigService enterpriseConfigService;
    @Autowired
    private InspectionTaskExpandService inspectionTaskExpandService;
    @Value(value="${node}")
    private Integer node;

    @Scheduled(fixedRate=1000L)
    @Transactional
    public void pollTasks() {
        try {
            if (ThreadNamePrefixEnum.CHOSEN.getCode().equals(this.node)) {
                log.info("Consume control is paused in blue. Skipping polling. node:{}", (Object)this.node);
                return;
            }
            if (!this.delayedTaskUtil.isConsumeEnabled()) {
                log.info("Task consumption is paused because restart. Skipping fetching tasks.");
                return;
            }
            Set readyTasks = this.delayedTaskUtil.fetchReadyTasks();
            for (Object task : readyTasks) {
                this.processTask(task);
            }
        }
        catch (Exception e) {
            log.error("Error while polling tasks: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void processTask(Object task) {
        String taskData = (String)task;
        String[] parts = taskData.split("::", 2);
        String taskKey = parts[0];
        String payload = parts.length > 1 ? parts[1] : null;
        try {
            TaskAndAuditDto taskObject = (TaskAndAuditDto)this.objectMapper.readValue(payload, TaskAndAuditDto.class);
            if (this.isTaskProcessed(taskKey, taskObject.getVersion())) {
                log.info("Task {} already processed, skipping.", (Object)taskKey);
                return;
            }
            this.executeBusinessLogic(taskKey, taskObject);
            this.markTaskAsProcessed(taskKey, taskObject.getVersion());
        }
        catch (Exception e) {
            log.error("Error processing task: {}", (Object)taskKey, (Object)e);
        }
    }

    private boolean isTaskProcessed(String taskKey, Integer version) {
        String statusKey = "task_status:" + taskKey + ":" + version;
        return Boolean.TRUE.equals(this.redisTemplate.opsForValue().get((Object)statusKey));
    }

    private void markTaskAsProcessed(String taskKey, Integer version) {
        String statusKey = "task_status:" + taskKey + ":" + version;
        this.redisTemplate.opsForValue().set((Object)statusKey, (Object)true, 24L, TimeUnit.HOURS);
        log.info("Task {} marked as processed.", (Object)taskKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBusinessLogic(String taskKey, TaskAndAuditDto taskAndAuditDto) {
        log.info("Task {} executed successfully with data: {}", (Object)taskKey, (Object)taskAndAuditDto);
        MDC.put((String)"TRACE_ID", (String)IdWorker.get32UUID());
        try {
            if (taskAndAuditDto == null || taskAndAuditDto.getUser() == null) {
                log.error("Invalid input: TaskAndAuditDto, User, or OrgTask is null. Skipping execution. Task ID: {}", (Object)taskAndAuditDto.getTaskId());
                return;
            }
            log.info("DelayedTaskListener invoked at {}, data: {}", (Object)DateUtils.format((Date)new Date(), (String)DateUtils.FORMAT_LONG), (Object)JSON.toJSONString((Object)taskAndAuditDto));
            InspectionTask orgTask = (InspectionTask)this.inspectionTaskMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(InspectionTask::getId, (Object)taskAndAuditDto.getTaskId())).eq(InspectionTask::getVersion, (Object)taskAndAuditDto.getVersion())).eq(InspectionTask::getIsDeleted, (Object)0));
            if (orgTask == null) {
                throw new SysErrorException(ResultCode.INSPECTION_PLAN_TASK_NULL, new Object[0]);
            }
            if (orgTask.getStatus() != InspectionTaskStatusEnum.AUDIT.getCode()) {
                log.warn("Task status is not AUDIT, skipping. Task ID: {}, Status: {}", (Object)orgTask.getId(), (Object)orgTask.getStatus());
                return;
            }
            Boolean canExpire = this.enterpriseConfigService.checkExpireExecute(taskAndAuditDto.getUser().getGroupId(), Arrays.asList(MainTypeEnum.INSPECTION.getCode()));
            if (ExpireStatusEnum.DEFAULT_TRUE.getCode() == orgTask.getExpireStatus() && !canExpire.booleanValue()) {
                log.info("Task ID: {} is expired and canExpire is false, skipping.", (Object)orgTask.getId());
                return;
            }
            if (Objects.nonNull(taskAndAuditDto) && Objects.nonNull(taskAndAuditDto.getNewAuditId())) {
                log.info("Forwarding audit to new auditor. Task ID: {}, New Auditor ID: {}", (Object)taskAndAuditDto.getTaskId(), (Object)taskAndAuditDto.getNewAuditId());
                Users users1 = this.usersRemoteService.getById(taskAndAuditDto.getNewAuditId());
                String auditName = Optional.ofNullable(users1).map(Users::getShowName).orElse("");
                this.inspectionTaskMapper.updateAuditIdById(taskAndAuditDto.getNewAuditId(), auditName, taskAndAuditDto.getTaskId());
                this.inspectionTaskService.insertLogOfRemark(OperatorTypeEnum.AUDITOR.getCode(), OperatorActionEnum.TRANSFER.getCode(), taskAndAuditDto.getOldAuditor(), taskAndAuditDto.getTaskId(), null, LogConstant.AUTO_DISTRIBUTE, this.calculateTimeDifference(taskAndAuditDto.getTriggerTime(), taskAndAuditDto.getLastNow()), taskAndAuditDto.getNewAuditName());
                InspectionAuditConfigFirstVersionModel updateModel = new InspectionAuditConfigFirstVersionModel();
                updateModel.setFirstTriggerFlag(Boolean.valueOf(true));
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(InspectionAuditConfigFirstVersionModel::getTaskId, (Object)taskAndAuditDto.getTaskId());
                log.info("Removing previous auditor's pending task. Task ID: {}, Old Auditor ID: {}", (Object)taskAndAuditDto.getTaskId(), (Object)taskAndAuditDto.getOldAuditId());
                DeleteMessagesByObject audit = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(orgTask.getId()).targetUserId(taskAndAuditDto.getOldAuditId()).objectType(MessageObjectEnum.DEFAULT.getDesc()).isComplete(YesEnum.DELETED.getCode()).build();
                this.messageProxy.deleteMessagesByObject(audit);
                log.info("Sending notification to the new auditor. Task ID: {}, New Auditor ID: {}", (Object)taskAndAuditDto.getTaskId(), (Object)taskAndAuditDto.getNewAuditId());
                this.messageProxy.sendWebSocketAndJpush(taskAndAuditDto.getNewAuditId(), taskAndAuditDto.getUser().getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.ADD_MESSAGE, taskAndAuditDto.getUser().getShowName(), taskAndAuditDto.getTaskName()), taskAndAuditDto.getUser().getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, taskAndAuditDto.getTaskId(), InspectionPlanMainTypeEnum.INSPECTION, taskAndAuditDto.getTokenType(), JumpTypeEnum.AUDIT.getCode(), IsExecutorEnum.EXECUTOR.getCode(), IsTodoMessageEnum.IS_TODO_MESSAGE.getCode(), taskAndAuditDto.getEndTime());
            } else {
                log.info("Automatically approving audit. Task ID: {}", (Object)taskAndAuditDto.getTaskId());
                this.inspectionTaskService.insertLogOfRemark(OperatorTypeEnum.AUDITOR.getCode(), OperatorActionEnum.AUDIT_PASS.getCode(), taskAndAuditDto.getOldAuditor(), taskAndAuditDto.getTaskId(), null, LogConstant.AUTO_PASS, this.calculateTimeDifference(taskAndAuditDto.getTriggerTime(), taskAndAuditDto.getLastNow()));
                this.inspectionTaskMapper.updateStatusById(InspectionTaskStatusEnum.PASS.getCode(), taskAndAuditDto.getTaskId(), new Date());
                log.info("Completing previous auditor's pending task. Task ID: {}, Old Auditor ID: {}", (Object)taskAndAuditDto.getTaskId(), (Object)taskAndAuditDto.getOldAuditId());
                DeleteMessagesByObject audit = new DeleteMessagesByObjectBuilder().isTodoMessage(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode()).subId(orgTask.getId()).targetUserId(taskAndAuditDto.getOldAuditId()).objectType(MessageObjectEnum.DEFAULT.getDesc()).isComplete(YesEnum.NOT_DELETED.getCode()).build();
                this.messageProxy.deleteMessagesByObject(audit);
                log.info("Sending notification to the new auditor. Task ID: {}, New Auditor ID: {}", (Object)taskAndAuditDto.getTaskId(), (Object)taskAndAuditDto.getNewAuditId());
                int count = this.inspectionTaskExpandService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(InspectionTaskExpand::getTaskId, (Object)orgTask.getId())).eq(InspectionTaskExpand::getOperatorId, (Object)orgTask.getOperatorId())).eq(InspectionTaskExpand::getStatus, (Object)InspectionTaskExpandStatusEnum.WAIT.getCode())).eq(InspectionTaskExpand::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode()));
                log.info("Sending notification to the executor. Task ID: {}, Executor ID: {},count:{}", new Object[]{taskAndAuditDto.getTaskId(), orgTask.getOperatorId(), count});
                this.messageProxy.sendWebSocketAndJpush(orgTask.getOperatorId(), taskAndAuditDto.getUser().getId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.PASS_MESSAGE, orgTask.getName()), taskAndAuditDto.getUser().getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, orgTask.getId(), InspectionPlanMainTypeEnum.INSPECTION, taskAndAuditDto.getTokenType(), JumpTypeEnum.DETAIL.getCode(), count > 0 ? IsExecutorEnum.EXECUTOR.getCode() : null, count > 0 ? IsTodoMessageEnum.IS_TODO_MESSAGE.getCode() : null, count > 0 ? orgTask.getEndTime() : null);
            }
        }
        catch (Exception e) {
            log.error("DelayedTaskListener error\uff0c{},taskId:{}", (Object)e.getMessage(), (Object)taskAndAuditDto.getTaskId());
        }
        finally {
            MDC.remove((String)"TRACE_ID");
        }
    }

    private String calculateTimeDifference(Date calculatedDate, Date now) {
        long differenceInMillis = calculatedDate.getTime() - now.getTime();
        if (differenceInMillis <= 0L) {
            return "\u5df2\u8d85\u65f6";
        }
        long totalMinutes = Math.round((double)differenceInMillis / 60000.0);
        long days = totalMinutes / 1440L;
        long hours = totalMinutes % 1440L / 60L;
        long minutes = totalMinutes % 60L;
        StringBuilder timeDiff = new StringBuilder();
        if (days > 0L) {
            timeDiff.append(days).append("\u5929");
        }
        if (hours > 0L) {
            timeDiff.append(hours).append("\u5c0f\u65f6");
        }
        if (minutes > 0L || timeDiff.length() == 0) {
            timeDiff.append(minutes).append("\u5206\u949f");
        }
        return timeDiff.toString();
    }
}

