/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.delayqueue;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ovopark.config.redis.DistributedDelayedQueueListener;
import com.ovopark.model.dto.TaskAndAuditDto;
import com.ovopark.service.InspectionTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemindsTaskListener
implements DistributedDelayedQueueListener<String> {
    private static final Logger log = LoggerFactory.getLogger(RemindsTaskListener.class);
    @Autowired
    private InspectionTaskService inspectionTaskService;

    @Override
    public void init() {
        log.info("\u9879\u76ee\u542f\u52a8\u65f6\u521d\u59cb");
    }

    @Override
    public void invoke(String str) {
        log.info("TaskAndAuditDto: {}", (Object)str);
        MDC.put((String)"TRACE_ID", (String)IdWorker.get32UUID());
        try {
            TaskAndAuditDto andAuditDto = (TaskAndAuditDto)JSON.parseObject((String)str, TaskAndAuditDto.class);
            log.info("TaskAndAuditDto: {}", (Object)andAuditDto.getTaskId());
            this.inspectionTaskService.executeBusinessLogic(andAuditDto.getTaskId(), andAuditDto);
        }
        catch (Exception e) {
            log.error("Error occurred during task execution: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            MDC.remove((String)"TRACE_ID");
        }
    }
}

