/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.delayqueue;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ovopark.config.redis.DistributedDelayedQueueListener;
import com.ovopark.model.event.TaskEndEvent;
import com.ovopark.model.req.InspectionPlanTaskExpireReq;
import com.ovopark.service.InspectionTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskEndLister
implements DistributedDelayedQueueListener<String> {
    private static final Logger log = LoggerFactory.getLogger(TaskEndLister.class);
    @Autowired
    private InspectionTaskService taskService;

    @Override
    public void init() {
        log.info("\u9879\u76ee\u542f\u52a8\u65f6\u521d\u59cb");
    }

    @Override
    public void invoke(String str) {
        MDC.put((String)"TRACE_ID", (String)IdWorker.get32UUID());
        log.info("TaskEndEvent: {}", (Object)str);
        try {
            TaskEndEvent endEvent = (TaskEndEvent)JSON.parseObject((String)str, TaskEndEvent.class);
            log.info("TaskEndEvent: {}", (Object)endEvent.getTaskId());
            this.taskService.expire(InspectionPlanTaskExpireReq.builder().id(endEvent.getTaskId()).build());
        }
        catch (Exception e) {
            log.error("Error occurred during task execution: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            MDC.remove((String)"TRACE_ID");
        }
    }
}

