/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.proxy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.api.JpushMessageApi;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.jpush.MessageBody;
import com.ovopark.messagehub.sdk.TodoMessageV2Api;
import com.ovopark.mo.PushNotificationMo;
import com.ovopark.model.dto.message.BaseMessageDTO;
import com.ovopark.model.dto.message.JPushMessageDTO;
import com.ovopark.model.dto.message.MCMessageDTO;
import com.ovopark.model.dto.message.ThirdMessageDTO;
import com.ovopark.model.dto.message.WebSocketMessageDTO;
import com.ovopark.model.enums.InspectionPlanMainTypeEnum;
import com.ovopark.model.enums.IsExecutorEnum;
import com.ovopark.model.enums.IsTodoMessageEnum;
import com.ovopark.model.pojo.MsgToUserPojo;
import com.ovopark.model.resp.JsonNewResult;
import com.ovopark.organize.common.model.mo.MessageMo;
import com.ovopark.organize.sdk.api.MessageApi;
import com.ovopark.po.DeleteMessagesByObject;
import com.ovopark.po.TaskMessage;
import com.ovopark.pojo.BaseResult;
import com.ovopark.service.Impl.CompositeNotificationSenderImpl;
import com.ovopark.service.Impl.JPushNotificationSenderImpl;
import com.ovopark.service.Impl.MCMessageServiceImpl;
import com.ovopark.service.Impl.ThirdMessageNotificationSenderImpl;
import com.ovopark.service.Impl.WebsocketNotificationSenderImpl;
import com.ovopark.service.TodoService;
import com.ovopark.utils.DateUtil;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.HttpUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MessageProxy {
    private static final Logger log = LoggerFactory.getLogger(MessageProxy.class);
    private static Logger logger = LoggerFactory.getLogger(MessageProxy.class);
    @Value(value="${websocket.url}")
    private String webSocketServerUrl;
    @Autowired
    private JpushMessageApi jpushMessageApi;
    @Value(value="${enableMessage:false}")
    private Boolean enableMessage;
    public static final ExecutorService executor = Executors.newFixedThreadPool(5);
    @Autowired
    private MessageApi messageApi;
    @Autowired
    private WebsocketNotificationSenderImpl websocketNotificationSender;
    @Autowired
    private JPushNotificationSenderImpl jPushNotificationSender;
    @Autowired
    private MCMessageServiceImpl mcMessageService;
    @Autowired
    private ThirdMessageNotificationSenderImpl thirdMessageNotificationSender;
    @Autowired
    private ObjectFactory<CompositeNotificationSenderImpl> compositeNotificationSenderObjectFactory;
    @Autowired
    private TodoService todoService;
    @Autowired
    private TodoMessageV2Api todoMessageV2Api;

    public void sendWebSocketAndJpush(final Integer targetUserId, final Integer userId, final String title, final String message, final Integer groupId, final Integer type, final Integer relatedId, final InspectionPlanMainTypeEnum mainType, final Integer tokenType, final Integer jumpType, final Integer isExecutor, final Integer isTodoMessage, final Date endTime) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                List messageDTOList = MessageProxy.this.buildMessageDTOList(targetUserId, userId, title, message, groupId, type, relatedId, mainType, tokenType, jumpType, isExecutor, isTodoMessage, endTime);
                if (MessageProxy.this.enableMessage.booleanValue() && Objects.isNull(isTodoMessage)) {
                    CompositeNotificationSenderImpl compositeNotificationSender = (CompositeNotificationSenderImpl)MessageProxy.this.compositeNotificationSenderObjectFactory.getObject();
                    compositeNotificationSender.add(MessageProxy.this.websocketNotificationSender);
                    compositeNotificationSender.add(MessageProxy.this.jPushNotificationSender);
                    compositeNotificationSender.add(MessageProxy.this.mcMessageService);
                    compositeNotificationSender.add(MessageProxy.this.thirdMessageNotificationSender);
                    compositeNotificationSender.sendNotification(messageDTOList);
                } else {
                    MessageProxy.this.todoService.saveTodo(messageDTOList);
                }
            }
        });
    }

    private List<BaseMessageDTO> buildMessageDTOList(Integer targetUserId, Integer userId, String title, String message, Integer groupId, Integer type, Integer relatedId, InspectionPlanMainTypeEnum mainType, Integer tokenType, Integer jumpType, Integer isExecutor, Integer isTodoMessage, Date endTime) {
        WebSocketMessageDTO webSocketMessageDTO = WebSocketMessageDTO.builder().content(message).enterpriseId(groupId).targetUserId(targetUserId).userId(userId).type(type).relatedId(relatedId).objectType(mainType.getMsgDesc()).messageType(Integer.valueOf(1000)).jumpType(jumpType).build();
        JPushMessageDTO jPushMessageDTO = JPushMessageDTO.builder().userId(userId).targetUserId(targetUserId).title(title).type(type).relatedId(relatedId).jumpType(jumpType).objectType(mainType.getMsgDesc()).message(message).tokenType(tokenType).build();
        MCMessageDTO mcMessageDTO = MCMessageDTO.builder().userId(userId).enterpriseId(groupId).targetUserId(targetUserId).content(message).type(type).relatedId(relatedId).objectType(mainType.getMsgDesc()).category("TYPE_STORE_PLAN_SYSTEM").jumpType(jumpType).build();
        ThirdMessageDTO thirdMessageDTO = ThirdMessageDTO.builder().userId(userId).targetUserId(targetUserId).build();
        MsgToUserPojo msgToUserPojo = this.buildMsgToUserPojo(targetUserId, userId, title, message, groupId, type, relatedId, mainType, tokenType, jumpType, isExecutor, isTodoMessage, endTime);
        webSocketMessageDTO.setMsgToUserPojo(msgToUserPojo);
        jPushMessageDTO.setMsgToUserPojo(msgToUserPojo);
        mcMessageDTO.setMsgToUserPojo(msgToUserPojo);
        thirdMessageDTO.setMsgToUserPojo(msgToUserPojo);
        ArrayList<BaseMessageDTO> messageDTOList = new ArrayList<BaseMessageDTO>();
        messageDTOList.add((BaseMessageDTO)webSocketMessageDTO);
        messageDTOList.add((BaseMessageDTO)jPushMessageDTO);
        messageDTOList.add((BaseMessageDTO)mcMessageDTO);
        messageDTOList.add((BaseMessageDTO)thirdMessageDTO);
        return messageDTOList;
    }

    private MsgToUserPojo buildMsgToUserPojo(Integer targetUserId, Integer userId, String title, String message, Integer groupId, Integer type, Integer relatedId, InspectionPlanMainTypeEnum mainType, Integer tokenType, Integer jumpType, Integer isExecutor, Integer isTodoMessage, Date endTime) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", type);
        if (relatedId != null) {
            param.put("taskId", relatedId);
        }
        param.put("newObjectType", "INSPECTION_PLAN");
        MsgToUserPojo msgToUserPojo = new MsgToUserPojo();
        msgToUserPojo.setUserId(userId);
        msgToUserPojo.setTargetUserIds(Arrays.asList(targetUserId));
        msgToUserPojo.setTitle(title);
        msgToUserPojo.setMessage(message);
        msgToUserPojo.setGroupId(groupId);
        msgToUserPojo.setType(type);
        msgToUserPojo.setSubId(relatedId);
        msgToUserPojo.setObjectId(jumpType);
        msgToUserPojo.setIsExecutor(isExecutor);
        msgToUserPojo.setIsTodoMessage(isTodoMessage);
        msgToUserPojo.setEndTime(endTime);
        msgToUserPojo.setTargetUserId(targetUserId);
        msgToUserPojo.setObjectType(mainType.getMsgDesc());
        msgToUserPojo.setCategory("TYPE_STORE_PLAN_SYSTEM");
        msgToUserPojo.setDescription(JSONObject.toJSONString(param));
        msgToUserPojo.setDetails(JSONObject.toJSONString(param));
        msgToUserPojo.setOptionState(Integer.valueOf(0));
        msgToUserPojo.setUserId(targetUserId);
        if (IsTodoMessageEnum.IS_TODO_MESSAGE.getCode().equals(isTodoMessage)) {
            msgToUserPojo.setEndTime(endTime);
            msgToUserPojo.setIsExecutor(isExecutor != null ? isExecutor : IsExecutorEnum.EXECUTOR.getCode());
        }
        return msgToUserPojo;
    }

    private void JpushAndWebSocket(Integer userId, String title, String message, Integer type, Integer relatedId, String objectType, Integer tokenType, Integer jumpType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", title);
        map.put("userIdList", Arrays.asList(userId));
        map.put("messageType", type);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("taskId", relatedId);
        jsonMap.put("objectType", objectType);
        jsonMap.put("newObjectType", objectType);
        jsonMap.put("jumpType", jumpType);
        map.put("taskJson", jsonMap);
        map.put("reason", message);
        logger.info("\u6781\u5149\u63a8\u9001\u8bf7\u6c42\u53c2\u6570\u6570\u636e:" + JSON.toJSONString(map) + "tokenType" + tokenType);
        MessageBody body = new MessageBody();
        body.setType(type.intValue());
        body.setTaskJson(JSON.toJSONString(jsonMap));
        try {
            PushNotificationMo pushParam = new PushNotificationMo();
            pushParam.setBody(body);
            pushParam.setMessage(message);
            pushParam.setTitle(title);
            pushParam.setUserId(userId);
            pushParam.setMessageType(type);
            log.info("\u6781\u5149\u63a8\u9001\u63a5\u53e3\u8c03\u7528\u53c2\u6570\uff1a" + JSON.toJSONString(map));
            BaseResult result = this.jpushMessageApi.pushNotification(pushParam);
            log.info("\u6781\u5149\u63a8\u9001\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)result));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendWebSocket(String content, Integer userId, Integer targetUserId, Integer enterpriseId, Integer messageType, Integer type, Integer relatedId, String objectType, Integer jumpType, Integer isExecutor, Integer isTodoMessage, Date endTime) {
        Date now = new Date();
        String nowStr = DateUtil.format((Date)now);
        String category = "TYPE_STORE_PLAN_SYSTEM";
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap detailMap = new HashMap();
        param.put("type", type);
        if (relatedId != null) {
            param.put("taskId", relatedId);
        }
        MessageMo msg = new MessageMo();
        msg.setContent(content);
        msg.setCreateTime(DateUtils.format((Date)now, (String)DateUtils.FORMAT_LONG));
        msg.setEnterpriseId(enterpriseId);
        msg.setSrcUserId(userId);
        msg.setTargetUserId(targetUserId);
        msg.setObjectId(jumpType);
        msg.setSubId(relatedId);
        msg.setObjectType(objectType);
        msg.setCategory(category);
        msg.setDescription(JSONObject.toJSONString(param));
        msg.setOptionState(Integer.valueOf(0));
        msg.setIsTodoMessage(isTodoMessage != null ? isTodoMessage : IsTodoMessageEnum.MESSAGE.getCode());
        if (msg.getIsTodoMessage().equals(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode())) {
            msg.setEndTime(endTime);
            msg.setIsExecutor(isExecutor != null ? isExecutor : IsExecutorEnum.EXECUTOR.getCode());
        }
        param.put("newObjectType", "INSPECTION_PLAN");
        msg.setDetails(JSONObject.toJSONString(param));
        long id = (Long)this.messageApi.saveMessages(msg).getData();
        logger.info("\u6d88\u606f\u63a8\u9001\u8fd4\u56demessageId:" + id);
        TaskMessage message = new TaskMessage();
        message.setContent(content);
        message.setCreateTime(nowStr);
        message.setEnterpriseId(enterpriseId);
        message.setSrcUserId(userId);
        message.setTargetUserId(targetUserId);
        message.setSubId(relatedId);
        message.setObjectType(objectType);
        message.setDescription(JSONObject.toJSONString(param));
        message.setId(id);
        message.setStatus(Integer.valueOf(0));
        message.setCategory(category);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", targetUserId + "");
        map.put("clients", "Android,iOS");
        map.put("message", JSONObject.toJSONString((Object)message));
        map.put("messageType", String.valueOf(messageType));
        logger.info("webSocket\u8bf7\u6c42\u53c2\u6570" + JSON.toJSONString(map));
        String result = HttpUtils.sendJsonToOtherServerDefault((String)this.webSocketServerUrl, map);
        logger.info("webSocket\u8fd4\u56de\u7ed3\u679c" + result);
        JsonNewResult jsonNewResult = (JsonNewResult)JSON.parseObject((String)result, JsonNewResult.class);
        if (jsonNewResult == null || jsonNewResult.getIsError().booleanValue()) {
            throw new SysErrorException(ResultCode.WEBSOECK_ERROR, new Object[0]);
        }
    }

    public void deleteMessagesByObject(DeleteMessagesByObject msg) {
        log.info("delete or complete todo messages input:{}" + JSON.toJSONString((Object)msg));
        try {
            if (msg.getIsComplete() == 1) {
                com.ovopark.module.shared.BaseResult booleanBaseResult = this.todoMessageV2Api.deleteTodoMessage(InspectionPlanMainTypeEnum.INSPECTION.getMsgDesc(), msg.getObjectId(), "", msg.getSubId(), msg.getTargetUserId(), null, false);
                log.info("delete todo message return:{}" + JSON.toJSONString((Object)booleanBaseResult));
            } else {
                com.ovopark.module.shared.BaseResult booleanBaseResult = this.todoMessageV2Api.completeTodoMessage(InspectionPlanMainTypeEnum.INSPECTION.getMsgDesc(), msg.getObjectId(), "", msg.getSubId(), msg.getTargetUserId(), null, false);
                log.info("complete todo message return:{}" + JSON.toJSONString((Object)booleanBaseResult));
            }
        }
        catch (Exception e) {
            log.error("delete or complete todo message error:{}", (Throwable)e);
        }
    }

    public void deleteMessagesByObjectForPlan(DeleteMessagesByObject msg) {
        log.info("delete or complete todo messages input:{}" + JSON.toJSONString((Object)msg));
        try {
            if (msg.getIsComplete() == 1) {
                com.ovopark.module.shared.BaseResult booleanBaseResult = this.todoMessageV2Api.deleteTodoMessageOnlyForPlan(InspectionPlanMainTypeEnum.INSPECTION.getMsgDesc(), msg.getObjectId(), "", msg.getSubId(), msg.getTargetUserId(), null, false);
                log.info("delete todo message return:{}" + JSON.toJSONString((Object)booleanBaseResult));
            } else {
                com.ovopark.module.shared.BaseResult booleanBaseResult = this.todoMessageV2Api.completeTodoMessageOnlyForPlan(InspectionPlanMainTypeEnum.INSPECTION.getMsgDesc(), msg.getObjectId(), "", msg.getSubId(), msg.getTargetUserId(), null, false);
                log.info("complete todo message return:{}" + JSON.toJSONString((Object)booleanBaseResult));
            }
        }
        catch (Exception e) {
            log.error("delete or complete todo message error:{}", (Throwable)e);
        }
    }
}

