/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.proxy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.model.proxy.XxlJobInfoBo;
import com.ovopark.utils.HttpUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class XxlJobProxy {
    private static Logger logger = LoggerFactory.getLogger(XxlJobProxy.class);
    @Value(value="${shopjob.url}")
    private String xxljobUrl;
    @Value(value="${shopjob.executorId}")
    private String executorId;

    public Integer sendCronToJob(String jobType, String parameter, String cron, Integer userId, String name) {
        String url = this.xxljobUrl + "/jobinfo/addByShopwebSupport";
        XxlJobInfoBo job = new XxlJobInfoBo();
        job.setJobGroup(Integer.parseInt(this.executorId));
        job.setJobDesc(name);
        job.setExecutorRouteStrategy("ROUND");
        job.setJobCron(cron);
        job.setGlueType("BEAN");
        job.setExecutorHandler(jobType);
        job.setExecutorBlockStrategy("SERIAL_EXECUTION");
        job.setExecutorTimeout(0);
        job.setExecutorFailRetryCount(1);
        job.setAuthor(userId.toString());
        job.setAlarmEmail("xingrufeng@ovopark.com");
        job.setExecutorParam(parameter);
        job.setGlueRemark("\u9648\u5217\u4e2d\u5fc3");
        logger.info("\u6dfb\u52a0\u9648\u5217\u4e2d\u5fc3 \u8bf7\u6c42\u53c2\u6570:" + JSON.toJSONString((Object)job));
        String result = HttpUtils.sendJsonToOtherServer((String)url, (Object)job);
        logger.info("\u8c03\u7528\u5b9a\u65f6\u4efb\u52a1\u8fd4\u56de\u7ed3\u679c:" + result);
        JSONObject maps = JSONObject.parseObject((String)result);
        if (maps == null || maps.get("content") == null) {
            throw new SysErrorException(ResultCode.XXL_JOB_ERROR, new Object[0]);
        }
        int jobId = Integer.parseInt(maps.get("content").toString());
        return jobId;
    }

    public Map<String, Object> startJob(Integer jobId) {
        String url = this.xxljobUrl + "/jobinfo/startByShopwebSupport";
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("jobId", jobId);
        String result = HttpUtils.sendJsonToOtherServer((String)url, param);
        JSONObject maps = JSONObject.parseObject((String)result);
        return maps;
    }

    public Map<String, Object> stopJob(Integer jobId) {
        String url = this.xxljobUrl + "/jobinfo/stopByShopwebSupport";
        if (Objects.isNull(jobId) || jobId == 0) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("id", jobId);
        String result = HttpUtils.sendJsonToOtherServer((String)url, param);
        logger.info("\u505c\u6b62\u6267\u884c\u5668\u8c03\u7528:{}", (Object)result);
        JSONObject maps = JSONObject.parseObject((String)result);
        return maps;
    }

    public Map<String, Object> removeJob(Integer jobId) {
        String url = this.xxljobUrl + "/jobinfo/removeByShopwebSupport";
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("jobId", jobId);
        String result = HttpUtils.sendJsonToOtherServer((String)url, param);
        JSONObject maps = JSONObject.parseObject((String)result);
        return maps;
    }

    public String getXxljobUrl() {
        return this.xxljobUrl;
    }

    public void setXxljobUrl(String xxljobUrl) {
        this.xxljobUrl = xxljobUrl;
    }
}

