/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.ovopark.device.cloud.api.DeviceApi;
import com.ovopark.device.common.response.BaseResult;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.service.DeviceService;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceServiceImpl
implements DeviceService {
    private static final Logger log = LoggerFactory.getLogger(DeviceServiceImpl.class);
    @Autowired
    private DeviceApi deviceApi;

    @Override
    public Map<Integer, Integer> getDepDeviceCount(Integer groupId) {
        Map<Integer, Integer> map = new HashMap<Integer, Integer>();
        BaseResult result = this.deviceApi.getDeptDevicesNum(groupId);
        log.info("\u67e5\u8be2\u4f01\u4e1a\u7684\u8bbe\u5907\u6570\u8fd4\u56de\uff1a{},{}", (Object)result.getIsError(), (Object)result.getRequestId());
        if (result.getIsError().booleanValue()) {
            throw new SysErrorException(ResultCode.SYS_ERROR, new Object[0]);
        }
        if (result.getData() != null) {
            map = (Map)result.getData();
        }
        return map;
    }

    @Override
    public Set<Integer> havaDeviceDep(Integer groupId) {
        Set<Integer> integers = this.getDepDeviceCount(groupId).keySet();
        if (integers.isEmpty()) {
            throw new SysErrorException(ResultCode.DEP_NO_DEVICE, new Object[0]);
        }
        return integers;
    }
}

