/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.ovopark.constants.MessageConstant;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.mapper.InspectionDeptTagMapper;
import com.ovopark.mapper.InspectionTagMapper;
import com.ovopark.mapper.InspectionTaskExpandMapper;
import com.ovopark.model.dto.ExpandCountDto;
import com.ovopark.model.dto.InspectionPlanDto;
import com.ovopark.model.dto.InspectionPlanDtoOpen;
import com.ovopark.model.dto.InspectionTagDto;
import com.ovopark.model.dto.PlanDataTopDetail;
import com.ovopark.model.enums.DefaultEnum;
import com.ovopark.model.enums.ExpandExecuteExpireEnum;
import com.ovopark.model.enums.InspectionPlanMainTypeEnum;
import com.ovopark.model.enums.InspectionTaskExpandStatusEnum;
import com.ovopark.model.enums.InspectionTaskStatusEnum;
import com.ovopark.model.enums.IsExecutorEnum;
import com.ovopark.model.enums.IsTodoMessageEnum;
import com.ovopark.model.enums.JumpTypeEnum;
import com.ovopark.model.enums.MainTypeEnum;
import com.ovopark.model.login.Users;
import com.ovopark.model.req.FixReq;
import com.ovopark.model.req.GetPlanParam;
import com.ovopark.model.req.GetPlansResp;
import com.ovopark.model.req.InsertReasonReq;
import com.ovopark.model.req.InspectionPlanTaskSecondOpenReq;
import com.ovopark.model.req.WebDetailReq;
import com.ovopark.model.resp.InspectionPlanDtoResp;
import com.ovopark.model.resp.InspectionPlanOpen;
import com.ovopark.model.resp.WebDetailResp;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.EnterpriseConfigPojo;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.po.InspectionTask;
import com.ovopark.po.InspectionTaskExpand;
import com.ovopark.po.IsInspectionDeptTemplate;
import com.ovopark.proxy.DepartProxy;
import com.ovopark.proxy.MessageProxy;
import com.ovopark.proxy.OrganizeProxy;
import com.ovopark.service.InspectionDeptTagService;
import com.ovopark.service.InspectionPlanProxyService;
import com.ovopark.service.InspectionTaskExpandService;
import com.ovopark.service.InspectionTaskService;
import com.ovopark.service.IsCheckTemplateService;
import com.ovopark.service.IsInspectionDeptTemplateService;
import com.ovopark.service.UsersRemoteService;
import com.ovopark.utils.BigDecimalUtils;
import com.ovopark.utils.ClazzConverterUtils;
import com.ovopark.utils.DateUtil;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.ListUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionTaskExpandServiceImpl
extends ServiceImpl<InspectionTaskExpandMapper, InspectionTaskExpand>
implements InspectionTaskExpandService {
    private static final Logger log = LoggerFactory.getLogger(InspectionTaskExpandServiceImpl.class);
    @Autowired
    private InspectionTaskExpandMapper inspectionTaskExpandMapper;
    @Autowired
    MessageProxy messageProxy;
    @Autowired
    private IsInspectionDeptTemplateService deptTemplateService;
    @Autowired
    private InspectionTaskService taskService;
    @Autowired
    private DepartProxy departProxy;
    @Autowired
    private UsersRemoteService usersRemoteService;
    @Autowired
    private EnterpriseGroupsApi enterpriseGroupsApi;
    @Autowired
    private OrganizeProxy organizeProxy;
    @Autowired
    private InspectionDeptTagService deptTagService;
    @Autowired
    private InspectionDeptTagMapper inspectionDeptTagMapper;
    @Autowired
    private InspectionTagMapper inspectionTagMapper;
    @Autowired
    private IsCheckTemplateService isCheckTemplateService;
    @Autowired
    private InspectionPlanProxyService inspectionPlanProxyService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void returnExpand(Integer expandId, Integer templateId, Integer operatorId, String templateName) {
        List expireExecutes;
        InspectionTaskExpand taskExpand;
        Date now = new Date();
        InspectionTaskExpand expand = (InspectionTaskExpand)this.getById(expandId);
        BaseResult result = this.enterpriseGroupsApi.getEnterpriseConfig(expand.getGroupId());
        DepartmentPojo department = this.departProxy.getDepartment(expand.getDeptId());
        Users users = this.usersRemoteService.getById(operatorId);
        if (templateId != null) {
            IsInspectionDeptTemplate one = (IsInspectionDeptTemplate)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.deptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getTemplateId, (Object)templateId)).eq(IsInspectionDeptTemplate::getExpandId, (Object)expandId)).one();
            one.setIsRead(DefaultEnum.DEFAULT_FALSE.getCode());
            this.deptTemplateService.update(one);
        }
        if ((taskExpand = (InspectionTaskExpand)this.getById(expandId)).getStatus().equals(InspectionTaskExpandStatusEnum.WAIT.getCode())) {
            return;
        }
        InspectionTask task = (InspectionTask)this.taskService.getById(taskExpand.getTaskId());
        Integer executeExpire = ExpandExecuteExpireEnum.DEFAULT.getCode();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.deptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getExpandId, (Object)expandId)).eq(IsInspectionDeptTemplate::getIsRead, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List collect = list.stream().map(IsInspectionDeptTemplate::getUpdateTime).collect(Collectors.toList());
            Date maxDate = (Date)Collections.max(collect);
            executeExpire = maxDate.after(task.getEndTime()) ? ExpandExecuteExpireEnum.YES.getCode() : ExpandExecuteExpireEnum.NOT.getCode();
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(InspectionTaskExpand::getStatus, (Object)DefaultEnum.DEFAULT_FALSE.getCode())).set(InspectionTaskExpand::getFinishTime, null)).set(InspectionTaskExpand::getExecuteExpire, (Object)executeExpire)).eq(InspectionTaskExpand::getId, (Object)expandId)).update();
        Integer completeExpandCount = task.getCompleteExpandCount();
        boolean flag = task.getTotalExpandCount().equals(completeExpandCount);
        completeExpandCount = completeExpandCount > 0 ? Integer.valueOf(completeExpandCount - 1) : Integer.valueOf(0);
        BigDecimal percent = BigDecimalUtils.calculatePercent((Integer)completeExpandCount, (Integer)task.getTotalExpandCount(), (Integer)BigDecimalUtils.DEFAULT_SCALE_FOUR, (Integer)4);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.taskService.lambdaUpdate().eq(InspectionTask::getId, (Object)taskExpand.getTaskId())).set(InspectionTask::getCompleteExpandCount, (Object)completeExpandCount)).set(InspectionTask::getCompletePercent, (Object)percent)).set(InspectionTask::getStatus, (Object)(task.getStatus().equals(InspectionTaskStatusEnum.PASS.getCode()) ? InspectionTaskStatusEnum.PASS.getCode() : InspectionTaskStatusEnum.INSPECT.getCode()))).update();
        if (task.getEndTime().before(now) && result.getData() != null && StringUtils.isNotBlank((String)((EnterpriseConfigPojo)result.getData()).getExpireExecute()) && !(expireExecutes = Stream.of(((EnterpriseConfigPojo)result.getData()).getExpireExecute().split(",")).map(Integer::parseInt).collect(Collectors.toList())).contains(MainTypeEnum.INSPECTION.getCode())) {
            return;
        }
        if (flag) {
            this.messageProxy.sendWebSocketAndJpush(task.getOperatorId(), task.getAuditId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.RETURN_MESSAGE, task.getName()), task.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, task.getId(), InspectionPlanMainTypeEnum.INSPECTION, DefaultEnum.DEFAULT_TRUE.getCode(), JumpTypeEnum.DETAIL.getCode(), IsExecutorEnum.EXECUTOR.getCode(), IsTodoMessageEnum.IS_TODO_MESSAGE.getCode(), task.getEndTime());
        }
    }

    @Override
    public void fix(FixReq req) {
        List tasks = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.taskService.lambdaQuery().eq(InspectionTask::getGroupId, (Object)req.getGroupId())).between(InspectionTask::getEndTime, (Object)req.getStartTime(), (Object)req.getEndTime())).eq(InspectionTask::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode())).list();
        Map<Object, Object> taskMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)tasks)) {
            taskMap = tasks.stream().collect(Collectors.toMap(InspectionTask::getId, InspectionTask::getEndTime));
            List expands = ((LambdaQueryChainWrapper)this.lambdaQuery().in(InspectionTaskExpand::getTaskId, taskMap.keySet())).list();
            if (CollectionUtils.isNotEmpty((Collection)expands)) {
                Map<Object, Object> expandTemplateMap = new HashMap();
                List expandIds = expands.stream().map(InspectionTaskExpand::getId).collect(Collectors.toList());
                List deptTemplates = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.deptTemplateService.lambdaQuery().in(IsInspectionDeptTemplate::getExpandId, expandIds)).eq(IsInspectionDeptTemplate::getIsRead, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).list();
                if (CollectionUtils.isNotEmpty((Collection)deptTemplates)) {
                    expandTemplateMap = deptTemplates.stream().collect(Collectors.groupingBy(IsInspectionDeptTemplate::getExpandId, Collectors.collectingAndThen(Collectors.reducing((c1, c2) -> c1.getUpdateTime().after(c2.getUpdateTime()) ? c1 : c2), Optional::get)));
                }
                HashMap finalExpandTemplateMap = expandTemplateMap;
                Map<Object, Object> finalTaskMap = taskMap;
                ((Stream)expands.stream().parallel()).forEach(i -> {
                    IsInspectionDeptTemplate deptTemplate = (IsInspectionDeptTemplate)finalExpandTemplateMap.get(i.getId());
                    if (deptTemplate != null && deptTemplate.getUpdateTime().after((Date)finalTaskMap.get(i.getTaskId()))) {
                        i.setExecuteExpire(ExpandExecuteExpireEnum.YES.getCode());
                    }
                    if (deptTemplate != null && i.getStatus().equals(InspectionTaskExpandStatusEnum.PASS.getCode())) {
                        i.setFinishTime(deptTemplate.getUpdateTime());
                    }
                    if (deptTemplate == null && i.getStatus().equals(InspectionTaskExpandStatusEnum.PASS.getCode())) {
                        i.setFinishTime(i.getUpdateTime());
                    }
                    if (deptTemplate == null && i.getStatus().equals(InspectionTaskExpandStatusEnum.WAIT.getCode())) {
                        i.setExecuteExpire(ExpandExecuteExpireEnum.DEFAULT.getCode());
                    }
                });
                expands.forEach(System.out::println);
                this.saveOrUpdateBatch(expands);
            }
        }
    }

    @Override
    public List<ExpandCountDto> countFinish(List<Integer> taskIds) {
        return this.inspectionTaskExpandMapper.countFinish(taskIds);
    }

    @Override
    public boolean deletedDepFix(Users users, Integer teskId) {
        InspectionTask task = (InspectionTask)this.taskService.getById(teskId);
        if (task.getAuditId().equals(users.getId()) && !task.getOperatorId().equals(users.getId())) {
            log.info("\u5ba1\u6838\u4eba\u4e0d\u8fdb\u884c\u72b6\u6001\u53d8\u66f4");
            return false;
        }
        List inspectionTaskExpands = this.inspectionTaskExpandMapper.selectExpandListByTaskId(teskId, users.getGroupId());
        Integer finishCount = 0;
        Integer unfinishCount = 0;
        List<Integer> deletedDepIds = this.departProxy.getDeletedDepIds(users.getGroupId());
        for (InspectionTaskExpand expand : inspectionTaskExpands) {
            finishCount = finishCount + (InspectionTaskExpandStatusEnum.PASS.getCode().equals(expand.getStatus()) ? 1 : 0);
            if (!InspectionTaskExpandStatusEnum.WAIT.getCode().equals(expand.getStatus())) continue;
            if (CollectionUtils.isNotEmpty(deletedDepIds)) {
                unfinishCount = unfinishCount + (!deletedDepIds.contains(expand.getDeptId()) ? 1 : 0);
                continue;
            }
            unfinishCount = unfinishCount + 1;
        }
        log.info("\u5df2\u5b8c\u6210\u7684\u4efb\u52a1\u6570\uff1a{},\u672a\u5b8c\u6210\u6570\uff1a{}", (Object)finishCount, (Object)unfinishCount);
        if (unfinishCount > 0) {
            return false;
        }
        boolean update = ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.taskService.lambdaUpdate().eq(InspectionTask::getId, (Object)teskId)).set(InspectionTask::getStatus, (Object)(finishCount == 0 ? InspectionTaskStatusEnum.INVALID.getCode() : InspectionTaskStatusEnum.FINISH.getCode()))).update();
        return update;
    }

    @Override
    public Page<WebDetailResp> webDetails(WebDetailReq req, Users user) {
        Page page = (Page)this.inspectionTaskExpandMapper.selectJoinPage((IPage)new Page((long)req.getPage().intValue(), (long)req.getPageSize().intValue()), WebDetailResp.class, (MPJBaseJoin)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper().selectAs(InspectionTask::getCreateTime, WebDetailResp::getCreateTime)).selectAs(InspectionTask::getName, WebDetailResp::getTaskName)).selectAs(InspectionTask::getId, WebDetailResp::getTaskId)).selectAs(InspectionTaskExpand::getId, WebDetailResp::getExpandId)).selectAs(InspectionTaskExpand::getDescription, WebDetailResp::getDescription)).selectAs(InspectionTaskExpand::getExpectTime, WebDetailResp::getExpectTime)).selectAs(InspectionTaskExpand::getFinishTime, WebDetailResp::getFinishTime)).selectAs(InspectionTaskExpand::getExecuteExpire, WebDetailResp::getExecuteExpire)).selectAs(InspectionTaskExpand::getOperatorId, WebDetailResp::getOperatorId)).selectAs(InspectionTaskExpand::getDeptId, WebDetailResp::getDepId)).selectAs(InspectionTaskExpand::getStatus, WebDetailResp::getStatus)).selectAs(InspectionTaskExpand::getMainType, WebDetailResp::getMainType)).innerJoin(InspectionTask.class, InspectionTask::getId, InspectionTaskExpand::getTaskId)).in(CollectionUtils.isNotEmpty((Collection)req.getStorePlanIds()), InspectionTaskExpand::getTaskId, (Collection)req.getStorePlanIds())).eq(InspectionTask::getGroupId, (Object)user.getGroupId())).in(CollectionUtils.isNotEmpty((Collection)req.getOperatorIds()), InspectionTaskExpand::getOperatorId, (Collection)req.getOperatorIds())).between(req.getStartTime() != null && req.getEndTime() != null, InspectionTask::getStartTime, (Object)req.getStartTime(), (Object)req.getEndTime())).between(req.getStartTime() != null && req.getEndTime() != null, InspectionTask::getEndTime, (Object)req.getStartTime(), (Object)req.getEndTime())).between(req.getCreateStartTime() != null && req.getCreateEndTime() != null, InspectionTask::getCreateTime, (Object)req.getCreateStartTime(), (Object)req.getCreateEndTime())).ne(InspectionTask::getStatus, (Object)InspectionTaskStatusEnum.DEFAULT.getCode())).like(StringUtils.isNotBlank((String)req.getStorePlanName()), InspectionTask::getName, (Object)req.getStorePlanName())).isNotNull(req.getExpectStartTime() != null && req.getExpectEndTime() != null, InspectionTaskExpand::getExpectTime)).between(req.getExpectStartTime() != null && req.getExpectEndTime() != null, InspectionTaskExpand::getExpectTime, (Object)req.getExpectStartTime(), (Object)req.getExpectEndTime())).between(req.getFinishStartTime() != null && req.getFinishEndTime() != null, InspectionTaskExpand::getFinishTime, (Object)req.getFinishStartTime(), (Object)req.getFinishEndTime())).eq(req.getExecuteExpire() != null, InspectionTaskExpand::getExecuteExpire, (Object)req.getExecuteExpire())).eq(req.getStatus() != null, InspectionTaskExpand::getStatus, (Object)req.getStatus())).eq(InspectionTaskExpand::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode())).eq(InspectionTaskExpand::getGroupId, (Object)user.getGroupId())).eq(req.getMainType() != null, InspectionTaskExpand::getMainType, (Object)req.getMainType())).last(req.getFinishInTime() != null && req.getFinishInTime() == 1, "and t.finish_time is not null and t.expect_time is not null   and DATE(t.expect_time) >= DATE(t.finish_time) order by t1.create_time desc, t1.id asc")).last(req.getFinishInTime() != null && req.getFinishInTime() == 0, "and t.finish_time is not null and t.expect_time is not null   and DATE(t.finish_time) > DATE(t.expect_time) order by t1.create_time desc, t1.id asc")).last(req.getFinishInTime() == null, "order by t1.create_time desc, t1.id asc"));
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            ArrayList<Integer> depIds = new ArrayList<Integer>();
            ArrayList<Integer> operatorIds = new ArrayList<Integer>();
            ArrayList<Integer> expandIds = new ArrayList<Integer>();
            for (WebDetailResp record : page.getRecords()) {
                expandIds.add(record.getExpandId());
                depIds.add(record.getDepId());
                operatorIds.add(record.getOperatorId());
            }
            Map<Integer, String> userNameMap = this.usersRemoteService.getCoreUserNameMapByIds(operatorIds);
            Map<Integer, DepartmentPojo> depName = this.departProxy.getDepartments(depIds);
            Map<Integer, Map<String, String>> managerMap = this.departProxy.getManagerByDeptIds(depIds, user.getGroupId());
            Map<Integer, List<String>> orgMap = this.organizeProxy.selectOrganizeMap(operatorIds, user.getGroupId());
            Map<Integer, String> userParentMap = this.usersRemoteService.getParentUsersByUserIds(operatorIds, user.getGroupId());
            Map<Integer, String> userRoleMap = this.usersRemoteService.getIdAndNameByRoleId(operatorIds, user.getGroupId());
            Map<Integer, String> taskTemplateMap = this.deptTemplateService.getTaskTemplateMap(expandIds);
            Map<Integer, String> taskTagMap = this.deptTagService.getTaskTagMap(expandIds);
            for (WebDetailResp record : page.getRecords()) {
                if (depName.get(record.getDepId()) != null) {
                    record.setDepName(depName.get(record.getDepId()).getName());
                    record.setShopId(depName.get(record.getDepId()).getShopId());
                }
                record.setDdManagerName(Optional.ofNullable(managerMap.get(record.getDepId())).map(m -> (String)m.get("3")).orElse("--"));
                record.setAreaManagerName(Optional.ofNullable(managerMap.get(record.getDepId())).map(m -> (String)m.get("4")).orElse("--"));
                record.setTemplateName(Optional.ofNullable(taskTemplateMap.get(record.getExpandId())).orElse("--"));
                record.setTagName(taskTagMap.get(record.getExpandId()));
                record.setOperatorName(userNameMap.get(record.getOperatorId()));
                record.setOperatorParentName(userParentMap.get(record.getOperatorId()));
                record.setOperatorRole(userRoleMap.get(record.getOperatorId()));
                record.setOrgName(ListUtils.listStrToString(orgMap.get(record.getOperatorId())));
                if (record.getExpectTime() == null || record.getFinishTime() == null) continue;
                record.setFinishInTime(Integer.valueOf(DateUtils.getStartTimeOfDay((Date)record.getExpectTime()).compareTo(DateUtils.getStartTimeOfDay((Date)record.getFinishTime())) != -1 ? 1 : 0));
            }
        }
        return page;
    }

    @Override
    public Boolean insertReason(InsertReasonReq req) {
        InspectionTaskExpand expand = (InspectionTaskExpand)this.getById(req.getExpandId());
        if (expand == null) {
            return false;
        }
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(InspectionTaskExpand::getId, (Object)req.getExpandId())).set(InspectionTaskExpand::getReason, (Object)req.getReason())).update();
    }

    @Override
    public Map<String, Object> getReason(InsertReasonReq req) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        InspectionTaskExpand expand = (InspectionTaskExpand)this.getById(req.getExpandId());
        if (expand == null) {
            return map;
        }
        map.put("expandId", expand.getId());
        map.put("reason", expand.getReason());
        return map;
    }

    @Override
    public Map<Integer, PlanDataTopDetail> getPlans(GetPlanParam req) {
        List getPlansResps;
        log.info("\u83b7\u53d6\u8ba1\u5212:{}", (Object)JSON.toJSONString((Object)req));
        HashMap<Integer, PlanDataTopDetail> resultMap = new HashMap<Integer, PlanDataTopDetail>();
        ArrayList<Integer> expandids = new ArrayList<Integer>();
        if (req.getTemplateId() != null) {
            List<Integer> ids = this.deptTemplateService.getTaskIdByTemplateIdAndTime(req.getTemplateId(), req.getStartTime(), req.getEndTime(), req.getMainTypes());
            if (CollectionUtils.isNotEmpty(ids)) {
                expandids.addAll(ids);
            } else {
                log.info("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u4efb\u52a1");
                return resultMap;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(getPlansResps = this.inspectionTaskExpandMapper.selectJoinList(GetPlansResp.class, (MPJBaseJoin)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper().selectAs(InspectionTaskExpand::getExecuteExpire, GetPlansResp::getExecuteExpire)).selectAs(InspectionTaskExpand::getOperatorId, GetPlansResp::getOperatorId)).selectAs(InspectionTaskExpand::getDeptId, GetPlansResp::getDepId)).selectAs(InspectionTaskExpand::getStatus, GetPlansResp::getStatus)).innerJoin(InspectionTask.class, InspectionTask::getId, InspectionTaskExpand::getTaskId)).in(CollectionUtils.isNotEmpty(expandids), InspectionTaskExpand::getId, expandids)).between(req.getStartTime() != null && req.getEndTime() != null, InspectionTask::getCreateTime, (Object)req.getStartTime(), (Object)req.getEndTime())).in(CollectionUtils.isNotEmpty((Collection)req.getUserIds()), InspectionTaskExpand::getOperatorId, (Collection)req.getUserIds())).in(CollectionUtils.isNotEmpty((Collection)req.getDepIds()), InspectionTaskExpand::getDeptId, (Collection)req.getDepIds())).in(CollectionUtils.isNotEmpty((Collection)req.getMainTypes()), InspectionTaskExpand::getMainType, (Collection)req.getMainTypes())).ne(InspectionTask::getStatus, (Object)InspectionTaskStatusEnum.DEFAULT.getCode())).eq(InspectionTaskExpand::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode()))))) {
            Map<Integer, List<GetPlansResp>> operatorIdMap = getPlansResps.stream().collect(Collectors.groupingBy(req.getType() == 1 ? GetPlansResp::getOperatorId : GetPlansResp::getDepId));
            for (Map.Entry<Integer, List<GetPlansResp>> entry : operatorIdMap.entrySet()) {
                int finishIntimeCount = 0;
                int finishOuttimeCount = 0;
                for (GetPlansResp model : entry.getValue()) {
                    if (!InspectionTaskExpandStatusEnum.formatOrNull((Integer)model.getStatus()).statusPass()) continue;
                    if (model.getExecuteExpire().equals(ExpandExecuteExpireEnum.YES.getCode())) {
                        ++finishOuttimeCount;
                        continue;
                    }
                    ++finishIntimeCount;
                }
                PlanDataTopDetail detail = new PlanDataTopDetail();
                detail.setIpFinishCount(Integer.valueOf(finishIntimeCount + finishOuttimeCount));
                detail.setIpFinishOutTimeCount(Integer.valueOf(finishOuttimeCount));
                detail.setIpFinishInTimeCount(Integer.valueOf(finishIntimeCount));
                detail.setIpTotalCount(Integer.valueOf(entry.getValue().size()));
                detail.setIpFinishRate(BigDecimalUtils.calculatePercentMuti100((Integer)detail.getIpFinishCount(), (Integer)detail.getIpTotalCount(), (Integer)BigDecimalUtils.DEFAULT_SCALE_FOUR, (Integer)BigDecimalUtils.DEFAULT_SCALE));
                resultMap.putIfAbsent(entry.getKey(), detail);
            }
        }
        return resultMap;
    }

    @Override
    public IPage<InspectionPlanOpen> getPlans(Integer groupId, String startTime, String endTime, Integer pageNumber, Integer pageSize) {
        Date etime;
        Date stime;
        if (pageSize > 200) {
            log.info("pageSize\u4e0d\u80fd\u5927\u4e8e200");
            throw new SysErrorException("pageSize\u4e0d\u80fd\u5927\u4e8e200");
        }
        try {
            stime = DateUtils.parse((String)startTime, (String)DateUtils.FORMAT_LONG);
            etime = DateUtils.parse((String)endTime, (String)DateUtils.FORMAT_LONG);
        }
        catch (Exception e) {
            log.error("Error parsing date: startTime={}, endTime={}", new Object[]{startTime, endTime, e});
            throw new SysErrorException(ResultCode.PARAM_TIME_ERROR, new Object[]{"\u65f6\u95f4\u683c\u5f0f\u9519\u8bef"});
        }
        if (stime == null || etime == null) {
            log.error("Invalid date: startTime={}, endTime={}", (Object)startTime, (Object)endTime);
            throw new SysErrorException(ResultCode.PARAM_ERROR, new Object[0]);
        }
        Integer daysBetween = DateUtils.daysBetween((Date)stime, (Date)etime);
        if (daysBetween > 90) {
            log.info("\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc790\u5929");
            throw new SysErrorException(ResultCode.PARAM_TIME_RANG, new Object[]{"\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc790\u5929"});
        }
        InspectionPlanDtoResp planDto = null;
        ArrayList<InspectionPlanDtoResp> respList = new ArrayList<InspectionPlanDtoResp>();
        ArrayList<Integer> depIds = new ArrayList<Integer>();
        Map<Object, Object> deptNameMap = new HashMap();
        HashMap<Integer, InspectionTaskExpand> expandMap = new HashMap<Integer, InspectionTaskExpand>();
        ArrayList<Object> expandIds = new ArrayList();
        Map taskMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.taskService.lambdaQuery().eq(InspectionTask::getGroupId, (Object)groupId)).between(InspectionTask::getCreateTime, (Object)stime, (Object)etime)).eq(InspectionTask::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode())).ne(InspectionTask::getStatus, (Object)InspectionTaskStatusEnum.DEFAULT.getCode())).list().stream().collect(Collectors.toMap(InspectionTask::getId, Function.identity()));
        if (taskMap.isEmpty()) {
            log.info("No tasks found for groupId={}, startTime={}, endTime={}", new Object[]{groupId, startTime, endTime});
            return new Page();
        }
        IPage page = this.page((IPage)new Page((long)pageNumber.intValue(), (long)pageSize.intValue()), (Wrapper)new LambdaQueryWrapper().in(InspectionTaskExpand::getTaskId, taskMap.keySet()));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)page.getRecords())) {
            for (InspectionTaskExpand record : page.getRecords()) {
                InspectionPlanDtoResp resp = (InspectionPlanDtoResp)ClazzConverterUtils.converterClass((Object)record, InspectionPlanDtoResp.class);
                respList.add(resp);
                expandMap.put(record.getId(), record);
                depIds.add(record.getDeptId());
            }
        } else {
            return new Page();
        }
        deptNameMap = this.departProxy.getDeptNameMap(depIds);
        expandIds = new ArrayList(expandMap.keySet());
        Map<Object, Object> tagMap = new HashMap();
        List tagDtos = this.inspectionTagMapper.getListByTaskIds(taskMap.keySet(), groupId);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tagDtos)) {
            tagMap = tagDtos.stream().collect(Collectors.groupingBy(InspectionTagDto::getExpandId));
        }
        Map<Object, Object> expandTempMap = new HashMap();
        Map<Object, Object> templateNameMap = new HashMap();
        List list1 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.deptTemplateService.lambdaQuery().in(IsInspectionDeptTemplate::getTaskId, taskMap.keySet())).eq(IsInspectionDeptTemplate::getGroupId, (Object)groupId)).list();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)list1)) {
            List<Integer> templateIds = list1.stream().map(IsInspectionDeptTemplate::getTemplateId).distinct().collect(Collectors.toList());
            templateNameMap = this.isCheckTemplateService.getIdAndName(templateIds);
            expandTempMap = list1.stream().collect(Collectors.groupingBy(IsInspectionDeptTemplate::getExpandId, Collectors.toMap(IsInspectionDeptTemplate::getTemplateId, Function.identity())));
        }
        InspectionPlanTaskSecondOpenReq secondOpenReq = new InspectionPlanTaskSecondOpenReq();
        secondOpenReq.setDetailIds(expandIds);
        secondOpenReq.setPageSize(null);
        secondOpenReq.setPageNumber(null);
        Map<Object, Object> liveSecondsTotal = new HashMap();
        ArrayList<InspectionPlanDto> dtos = new ArrayList<InspectionPlanDto>();
        ArrayList<InspectionPlanOpen> openList = new ArrayList<InspectionPlanOpen>();
        for (InspectionPlanDtoResp inspectionPlanDtoResp : respList) {
            Map deptTemplateMap = Optional.ofNullable(expandTempMap.get(inspectionPlanDtoResp.getId())).orElse(new HashMap());
            if (MapUtils.isNotEmpty((Map)deptTemplateMap)) {
                for (Map.Entry entry : deptTemplateMap.entrySet()) {
                    InspectionPlanDto dto = new InspectionPlanDto();
                    dto.setDeptId(inspectionPlanDtoResp.getDeptId().intValue());
                    dto.setDeptName((String)deptNameMap.get(inspectionPlanDtoResp.getDeptId()));
                    dto.setDetailId(inspectionPlanDtoResp.getId());
                    dto.setTemplateId((Integer)entry.getKey());
                    dto.setTemplateName(templateNameMap.get(entry.getKey()) != null ? (String)templateNameMap.get(entry.getKey()) : "--");
                    dto.setStatus(((IsInspectionDeptTemplate)((Map)expandTempMap.get(inspectionPlanDtoResp.getId())).get(dto.getTemplateId())).getIsRead());
                    dto.setReason(((IsInspectionDeptTemplate)((Map)expandTempMap.get(inspectionPlanDtoResp.getId())).get(dto.getTemplateId())).getReason());
                    dto.setReason(((IsInspectionDeptTemplate)entry.getValue()).getReason());
                    dto.setExpectTimeStr(DateUtil.format((Date)inspectionPlanDtoResp.getExpectTime(), (String)DateUtil.FORMAT_SHORT));
                    dtos.add(dto);
                }
                continue;
            }
            InspectionPlanDto dto = new InspectionPlanDto();
            dto.setDeptId(inspectionPlanDtoResp.getDeptId().intValue());
            dto.setDeptName((String)deptNameMap.get(inspectionPlanDtoResp.getDeptId()));
            dto.setTemplateName("--");
            dto.setDetailId(inspectionPlanDtoResp.getId());
            dto.setReason(inspectionPlanDtoResp.getReason());
            dto.setStatus(inspectionPlanDtoResp.getStatus());
            dto.setExpectTimeStr(DateUtil.format((Date)inspectionPlanDtoResp.getExpectTime(), (String)DateUtil.FORMAT_SHORT));
            dtos.add(dto);
        }
        Map<Integer, List<InspectionPlanDto>> expandDtoMap = dtos.stream().collect(Collectors.groupingBy(InspectionPlanDto::getDetailId));
        planDto = this.inspectionPlanProxyService.secondWebList(secondOpenReq);
        if (planDto != null) {
            for (InspectionPlanDto dto : planDto.getData()) {
                InspectionPlanDto d;
                int i;
                List<InspectionPlanDto> inspectionPlanDtos;
                InspectionTaskExpand expand = (InspectionTaskExpand)expandMap.get((int)dto.getDetailId());
                InspectionTask task = (InspectionTask)taskMap.get(expand.getTaskId());
                if (expandTempMap.get(expand.getId()) != null && ((Map)expandTempMap.get(expand.getId())).get(dto.getTemplateId()) != null) {
                    inspectionPlanDtos = expandDtoMap.get(dto.getDetailId());
                    for (i = 0; i < inspectionPlanDtos.size(); ++i) {
                        d = inspectionPlanDtos.get(i);
                        if (!dto.getTemplateId().equals(d.getTemplateId())) continue;
                        d.setDeptId(dto.getDeptId());
                        d.setDeptName(dto.getDeptName());
                        d.setProblemNum(dto.getProblemNum());
                        d.setLiveSeconds(dto.getLiveSeconds());
                        d.setTotalProblemNum(dto.getTotalProblemNum());
                        d.setInvalidProblemNum(dto.getInvalidProblemNum());
                        d.setFinishTime(dto.getFinishTime());
                        d.setStartTime(dto.getStartTime());
                        d.setTaskId(dto.getTaskId());
                        d.setExecuteExpire(dto.getFinishTime() != null ? (dto.getFinishTime().after(task.getEndTime()) ? ExpandExecuteExpireEnum.YES.getCode() : ExpandExecuteExpireEnum.NOT.getCode()) : null);
                        d.setStatus(((IsInspectionDeptTemplate)((Map)expandTempMap.get(expand.getId())).get(dto.getTemplateId())).getIsRead());
                        d.setReason(((IsInspectionDeptTemplate)((Map)expandTempMap.get(expand.getId())).get(dto.getTemplateId())).getReason());
                        inspectionPlanDtos.set(i, d);
                    }
                    continue;
                }
                inspectionPlanDtos = expandDtoMap.get(dto.getDetailId());
                for (i = 0; i < inspectionPlanDtos.size(); ++i) {
                    d = inspectionPlanDtos.get(i);
                    if (!dto.getDetailId().equals(d.getDetailId())) continue;
                    d.setDeptId(dto.getDeptId());
                    d.setDeptName(dto.getDeptName());
                    d.setProblemNum(dto.getProblemNum());
                    d.setLiveSeconds(dto.getLiveSeconds());
                    d.setTotalProblemNum(dto.getTotalProblemNum());
                    d.setInvalidProblemNum(dto.getInvalidProblemNum());
                    d.setFinishTime(dto.getFinishTime());
                    d.setStartTime(dto.getStartTime());
                    d.setTaskId(dto.getTaskId());
                    d.setExecuteExpire(dto.getFinishTime() != null ? (dto.getFinishTime().after(task.getEndTime()) ? ExpandExecuteExpireEnum.YES.getCode() : ExpandExecuteExpireEnum.NOT.getCode()) : null);
                    d.setTemplateName(dto.getTemplateName());
                    inspectionPlanDtos.set(i, d);
                }
            }
            liveSecondsTotal = planDto.getData().stream().collect(Collectors.groupingBy(InspectionPlanDto::getDetailId, Collectors.summingLong(InspectionPlanDto::getLiveSeconds)));
        }
        for (InspectionPlanDtoResp resp : respList) {
            resp.setOperator(((InspectionTask)taskMap.get(resp.getTaskId())).getOperatorName());
            resp.setCreateTime(((InspectionTask)Optional.ofNullable(taskMap.get(resp.getTaskId())).get()).getCreateTime());
            resp.setLiveSeconds(liveSecondsTotal.get(resp.getId()) != null ? ((Long)liveSecondsTotal.get(resp.getId())).intValue() : 0);
            resp.setDeptName((String)deptNameMap.get(resp.getDeptId()));
            resp.setExecuteExpire(resp.getLiveSeconds() > 0 ? resp.getExecuteExpire() : null);
            resp.setExpectTimeStr(DateUtil.format((Date)resp.getExpectTime(), (String)DateUtil.FORMAT_SHORT));
            InspectionPlanOpen open = (InspectionPlanOpen)ClazzConverterUtils.converterClass((Object)resp, InspectionPlanOpen.class);
            open.setTagList(((List)Optional.ofNullable(tagMap.get(resp.getId())).orElse(new ArrayList())).stream().map(InspectionTagDto::getTagName).collect(Collectors.toList()));
            open.setTotalLiveSeconds(resp.getLiveSeconds());
            List details = ClazzConverterUtils.converterClass((Collection)expandDtoMap.get(resp.getId()), InspectionPlanDtoOpen.class);
            open.setData(details);
            openList.add(open);
        }
        Page page2 = new Page();
        BeanUtils.copyProperties((Object)page, (Object)page2);
        page2.setRecords(openList);
        return page2;
    }

    @Override
    public Map<Integer, Integer> getPlanNameByRelatedIds(List<Integer> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new HashMap<Integer, Integer>();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(InspectionTaskExpand::getId, ids)).list().stream().collect(Collectors.toMap(InspectionTaskExpand::getId, InspectionTaskExpand::getTaskId));
    }
}

