/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.ovopark.mapper.IsInspectionDeptTemplateMapper;
import com.ovopark.model.dto.DepTemplateDto;
import com.ovopark.model.dto.ExpandCountDto;
import com.ovopark.model.req.InsertReasonReq;
import com.ovopark.model.resp.InspectionPlanTemplateDetailResp;
import com.ovopark.po.IsInspectionDeptTemplate;
import com.ovopark.service.IsCheckTemplateService;
import com.ovopark.service.IsInspectionDeptTemplateService;
import com.ovopark.utils.ClazzConverterUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="isInspectionDeptTemplateService")
public class IsInspectionDeptTemplateServiceImpl
extends ServiceImpl<IsInspectionDeptTemplateMapper, IsInspectionDeptTemplate>
implements IsInspectionDeptTemplateService {
    @Resource
    private IsInspectionDeptTemplateMapper deptTemplateMapper;
    @Autowired
    private IsCheckTemplateService checkTemplateService;

    @Override
    public IsInspectionDeptTemplate queryById(Integer id) {
        return (IsInspectionDeptTemplate)this.getById(id);
    }

    @Override
    public IsInspectionDeptTemplate update(IsInspectionDeptTemplate isInspectionDeptTemplate) {
        this.updateById(isInspectionDeptTemplate);
        return this.queryById(isInspectionDeptTemplate.getId());
    }

    @Override
    public List<ExpandCountDto> haveNoFinish(Integer taskId) {
        return this.deptTemplateMapper.haveNoFinish(taskId);
    }

    @Override
    public Boolean insertReason(InsertReasonReq req) {
        IsInspectionDeptTemplate deptTemplate = (IsInspectionDeptTemplate)this.getById(req.getId());
        deptTemplate.setReason(req.getReason());
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(IsInspectionDeptTemplate::getId, (Object)req.getId())).set(IsInspectionDeptTemplate::getReason, (Object)req.getReason())).update();
    }

    @Override
    public Map<String, Object> getReason(InsertReasonReq req) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        IsInspectionDeptTemplate one = (IsInspectionDeptTemplate)((LambdaQueryChainWrapper)this.lambdaQuery().eq(IsInspectionDeptTemplate::getId, (Object)req.getId())).one();
        if (one != null) {
            map.put("id", one.getId());
            map.put("reason", one.getReason());
        }
        return map;
    }

    @Override
    public List<Integer> getTaskIdByTemplateIdAndTime(Integer templateId, String startTime, String endTime, List<Integer> mainTypes) {
        return this.deptTemplateMapper.getTaskIdByTemplateIdAndTime(templateId, startTime, endTime, mainTypes);
    }

    @Override
    public Map<Integer, String> getTaskTemplateMap(List<Integer> expandIds) {
        List<Integer> templateIds;
        Map<Integer, String> idAndName;
        Map<Integer, String> hashMap = new HashMap<Integer, String>();
        if (CollectionUtils.isEmpty(expandIds)) {
            return new HashMap<Integer, String>();
        }
        List depTemplateDtos = this.deptTemplateMapper.selectJoinList(DepTemplateDto.class, (MPJBaseJoin)((MPJLambdaWrapper)((MPJLambdaWrapper)new MPJLambdaWrapper().selectAs(IsInspectionDeptTemplate::getExpandId, DepTemplateDto::getExpandId)).selectAs(IsInspectionDeptTemplate::getTemplateId, DepTemplateDto::getTemplateId)).in(IsInspectionDeptTemplate::getExpandId, expandIds));
        if (CollectionUtils.isNotEmpty((Collection)depTemplateDtos) && !(idAndName = this.checkTemplateService.getIdAndName(templateIds = depTemplateDtos.stream().map(DepTemplateDto::getTemplateId).distinct().collect(Collectors.toList()))).isEmpty()) {
            for (DepTemplateDto depTemplateDto : depTemplateDtos) {
                depTemplateDto.setTemplateName(idAndName.get(depTemplateDto.getTemplateId()));
            }
            hashMap = depTemplateDtos.stream().collect(Collectors.groupingBy(DepTemplateDto::getExpandId, Collectors.mapping(DepTemplateDto::getTemplateName, Collectors.joining(","))));
        }
        return hashMap;
    }

    @Override
    public List<InspectionPlanTemplateDetailResp> getByExpandId(List<Integer> expandIds) {
        List list = this.deptTemplateMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(IsInspectionDeptTemplate::getExpandId, expandIds)).orderByDesc(IsInspectionDeptTemplate::getIsRead));
        return ClazzConverterUtils.converterClass((Collection)list, InspectionPlanTemplateDetailResp.class);
    }
}

