/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.alibaba.fastjson.JSON;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.model.enums.MenusPrivilegesEnum;
import com.ovopark.model.login.Users;
import com.ovopark.privilege.api.PrivilegeApi;
import com.ovopark.privilege.pojo.PrivilegesPojo;
import com.ovopark.privilege.response.BaseResult;
import com.ovopark.service.MenusPrivilegesService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenusPrivilegesServiceImpl
implements MenusPrivilegesService {
    private static final Logger log = LoggerFactory.getLogger(MenusPrivilegesServiceImpl.class);
    @Autowired
    private PrivilegeApi privilegeApi;

    @Override
    public Set<Integer> getUserPrivileges(Users user) {
        HashSet<Integer> privileges = new HashSet();
        log.info("getUserPrivileges\uff1a{}", (Object)JSON.toJSONString((Object)user));
        BaseResult result = this.privilegeApi.getUserPrivileges(user.getId(), user.getGroupId());
        log.info("getUserPrivileges return\uff1a{}", (Object)JSON.toJSONString((Object)result));
        if (CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            List list = ((List)result.getData()).stream().map(PrivilegesPojo::getPrivilegeName).distinct().collect(Collectors.toList());
            for (String s : list) {
                if (MenusPrivilegesEnum.INSPECTION == MenusPrivilegesEnum.formatOrNull((String)s)) {
                    privileges.add(MenusPrivilegesEnum.INSPECTION.getCode());
                    continue;
                }
                if (MenusPrivilegesEnum.SHOP_INSPECTION == MenusPrivilegesEnum.formatOrNull((String)s)) {
                    privileges.add(MenusPrivilegesEnum.SHOP_INSPECTION.getCode());
                    continue;
                }
                if (MenusPrivilegesEnum.ONLINE_INSPECTION != MenusPrivilegesEnum.formatOrNull((String)s)) continue;
                privileges.add(MenusPrivilegesEnum.ONLINE_INSPECTION.getCode());
            }
        }
        privileges = privileges.stream().filter(integer -> integer != 0).collect(Collectors.toSet());
        log.info("getUserPrivileges\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString(privileges));
        return privileges;
    }

    @Override
    public void checkPrivilege(Users user, Integer privilegeCode) {
        Set<Integer> userPrivileges = this.getUserPrivileges(user);
        if (!userPrivileges.contains(privilegeCode)) {
            throw new SysErrorException(ResultCode.STORE_PLAN_HAVE_NO_PRIVILEGE, new Object[0]);
        }
    }

    @Override
    public boolean checkPrivilegeReture(Users user, Integer privilegeCode) {
        Set<Integer> userPrivileges = this.getUserPrivileges(user);
        return userPrivileges.contains(privilegeCode);
    }

    @Override
    public void checkPlanPrivilege(Users user) {
        Set<Integer> userPrivileges = this.getUserPrivileges(user);
        if (!userPrivileges.contains(MenusPrivilegesEnum.ONLINE_INSPECTION.getCode()) && !userPrivileges.contains(MenusPrivilegesEnum.SHOP_INSPECTION.getCode())) {
            throw new SysErrorException(ResultCode.STORE_PLAN_HAVE_NO_CHECK_PRIVILEGE, new Object[0]);
        }
    }
}

