/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.alibaba.fastjson.JSON;
import com.ovopark.enums.NotificationTypeEnum;
import com.ovopark.messagehub.sdk.MessageHubV2Api;
import com.ovopark.messagehub.sdk.model.MessageRequest;
import com.ovopark.messagehub.sdk.model.ParamContext;
import com.ovopark.messagehub.sdk.model.SubsBuilders;
import com.ovopark.model.dto.message.BaseMessageDTO;
import com.ovopark.model.dto.message.WebSocketMessageDTO;
import com.ovopark.service.Impl.AbstractNotificationSender;
import java.util.Collections;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WebsocketNotificationSenderImpl
extends AbstractNotificationSender {
    private static final Logger log = LoggerFactory.getLogger(WebsocketNotificationSenderImpl.class);

    protected WebsocketNotificationSenderImpl(MessageHubV2Api messageHubV2Api) {
        super(messageHubV2Api);
    }

    @Override
    protected NotificationTypeEnum getType() {
        return NotificationTypeEnum.WEBSOCKET;
    }

    @Override
    public void sendNotification(BaseMessageDTO baseMessageDTO) {
        log.info("Start sending notification for message by webSocket: {}", (Object)JSON.toJSONString((Object)baseMessageDTO));
        try {
            this.validate(baseMessageDTO);
            MessageRequest message = this.buildMessage(baseMessageDTO);
            log.info("MessageRequest built successfully : {}", (Object)JSON.toJSONString((Object)message));
            super.preSendLog(baseMessageDTO, JSON.toJSONString((Object)baseMessageDTO));
            super.doSend(message);
            log.info("Message sent successfully for message DTO:{} with MessageRequest: {}", (Object)JSON.toJSONString((Object)baseMessageDTO), (Object)JSON.toJSONString((Object)message));
            super.postSendLog(baseMessageDTO, JSON.toJSONString((Object)baseMessageDTO));
            this.handleResult(baseMessageDTO);
        }
        catch (Exception e) {
            log.error("Error sending notification", (Throwable)e);
        }
    }

    @Override
    public boolean supports(BaseMessageDTO baseMessageDTO) {
        return baseMessageDTO instanceof WebSocketMessageDTO;
    }

    @Override
    protected void validate(BaseMessageDTO request) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (!(request instanceof WebSocketMessageDTO)) {
            throw new IllegalArgumentException("Invalid request type for WebSocket. Expected WebSocketMessageDTO.");
        }
    }

    @Override
    protected <T> MessageRequest buildMessage(T t) {
        log.info("Start building MessageRequest for object: {}", t);
        WebSocketMessageDTO webSocketMessageDTO = (WebSocketMessageDTO)t;
        MessageRequest messageRequest = ((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)SubsBuilders.flightWBS().toUserIdList(Collections.singletonList(webSocketMessageDTO.getTargetUserId()))).content(webSocketMessageDTO.getContent()).mcTitle(new ParamContext().plainText(webSocketMessageDTO.getTitle()))).locale(Locale.CHINA)).group(String.valueOf(webSocketMessageDTO.getEnterpriseId()))).client(new String[]{"iOS", "Android"}).messageType(String.valueOf(webSocketMessageDTO.getMessageType())).mcContent(webSocketMessageDTO.getContent())).build();
        log.info("MessageRequest built successfully: {}", (Object)JSON.toJSONString((Object)messageRequest));
        return messageRequest;
    }

    @Override
    protected void handleResult(BaseMessageDTO request) {
        log.info("Handling result for Websocket request: {}", (Object)JSON.toJSONString((Object)request));
    }
}

