/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.alibaba.fastjson.JSON;
import com.ovopark.enums.NotificationTypeEnum;
import com.ovopark.messagehub.sdk.MessageHubV2Api;
import com.ovopark.messagehub.sdk.model.MessageRequest;
import com.ovopark.model.dto.message.BaseMessageDTO;
import com.ovopark.service.Impl.AbstractNotificationSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WechatNotificationSenderImpl
extends AbstractNotificationSender {
    private static final Logger log = LoggerFactory.getLogger(WechatNotificationSenderImpl.class);

    protected WechatNotificationSenderImpl(MessageHubV2Api messageHubV2Api) {
        super(messageHubV2Api);
    }

    @Override
    protected NotificationTypeEnum getType() {
        return NotificationTypeEnum.WECHAT;
    }

    @Override
    protected void validate(BaseMessageDTO request) {
        log.info("Validating Wechat request: {}", (Object)JSON.toJSONString((Object)request));
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
    }

    @Override
    protected <T> MessageRequest buildMessage(T t) {
        return new MessageRequest();
    }

    @Override
    protected void handleResult(BaseMessageDTO request) {
    }

    @Override
    public boolean supports(BaseMessageDTO baseMessageDTO) {
        return false;
    }
}

