/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.modules.test;

import com.ovopark.iohub.modules.proto.JobFileIO;
import com.ovopark.iohub.modules.proto.SegmentCache;
import com.ovopark.iohub.modules.proto.outstream.DefaultHeaderFeatureExcelExportListener;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.Util;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Component;

@Component
public class DynamicHeaderAndMergeCellExportHeaderListener
extends DefaultHeaderFeatureExcelExportListener {
    public void onCell(int firstRow, int lastRow, int firstCol, int lastCol, Sheet sheet, Workbook workbook, Segment.Header.Cell defCell, Map<String, Object> segmentMeta, JobFileIO jobFileIO, SegmentCache segmentCache) {
        super.onCell(firstRow, lastRow, firstCol, lastCol, sheet, workbook, defCell, segmentMeta, jobFileIO, segmentCache);
    }

    protected void onFontFeature(int firstRow, int lastRow, int firstCol, int lastCol, Sheet sheet, Workbook workbook, Segment.Header.Cell defCell, Map<String, Object> segmentMeta, JobFileIO jobFileIO, SegmentCache segmentCache) {
        boolean fontEnabled = defCell.feature().isFontFeatureEnabled();
        if (!fontEnabled) {
            return;
        }
        Cell cell = sheet.getRow(firstRow).getCell(firstCol);
        Font font = workbook.createFont();
        if (Util.compare2((Comparable)Boolean.valueOf(defCell.feature().isBold()), (Comparable)Boolean.valueOf(true)) == 0) {
            font.setBold(true);
        }
        if (Util.compare2((Comparable)Boolean.valueOf(defCell.feature().isUnderline()), (Comparable)Boolean.valueOf(true)) == 0) {
            font.setUnderline((byte)1);
        }
        if (Util.compare2((Comparable)Boolean.valueOf(defCell.feature().isStrikeout()), (Comparable)Boolean.valueOf(true)) == 0) {
            font.setStrikeout(true);
        }
        if (Util.compare2((Comparable)Boolean.valueOf(defCell.feature().isItalic()), (Comparable)Boolean.valueOf(true)) == 0) {
            font.setItalic(true);
        }
        if (Util.isNotEmpty((CharSequence)defCell.feature().getColor())) {
            font.setColor(IndexedColors.valueOf((String)defCell.feature().getColor().toUpperCase()).getIndex());
        }
        CellStyle fontStyle = workbook.createCellStyle();
        fontStyle.cloneStyleFrom(cell.getCellStyle());
        fontStyle.setFont(font);
        cell.setCellStyle(fontStyle);
    }
}

