/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.modules.test;

import com.ovopark.iohub.modules.proto.JobFileIO;
import com.ovopark.iohub.modules.proto.SegmentCache;
import com.ovopark.iohub.modules.proto.outstream.DefaultCellFeatureExcelExportListener;
import com.ovopark.iohub.sdk.model.proto.Segment;
import java.util.Map;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Component;

@Component
public class DynamicHeaderAndMergeCellExportCellListener
extends DefaultCellFeatureExcelExportListener {
    public void onRow(Row row, Sheet sheet, Workbook workbook, Map<String, Object> rowMap, Map<String, Object> segmentMeta, JobFileIO jobFileIO, SegmentCache segmentCache) {
        super.onRow(row, sheet, workbook, rowMap, segmentMeta, jobFileIO, segmentCache);
        row.setHeight((short)-1);
    }

    public void onCell(final Cell cell, Row row, Sheet sheet, final Workbook workbook, Segment.Header.Cell defCell, Object cellValue, Map<String, Object> rowMap, Map<String, Object> segmentMeta, JobFileIO jobFileIO, SegmentCache segmentCache) {
        super.onCell(cell, row, sheet, workbook, defCell, cellValue, rowMap, segmentMeta, jobFileIO, segmentCache);
        CellStyle cellStyle = (CellStyle)segmentCache.putIfAbsentAndGet((Comparable)((Object)("custom_font_feature_" + defCell.path())), (Function)new Function<String, CellStyle>(){

            @Override
            public CellStyle apply(String k) {
                CellStyle cellStyle = workbook.createCellStyle();
                cellStyle.cloneStyleFrom(cell.getCellStyle());
                cellStyle.setWrapText(true);
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                return cellStyle;
            }
        }).value();
        cell.setCellStyle(cellStyle);
    }
}

