/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.iohub.sdk.model.proto.CellFile;
import com.ovopark.iohub.sdk.model.proto.LimitLogger;
import com.ovopark.iohub.sdk.model.proto.OnlyPrivate;
import com.ovopark.iohub.sdk.model.proto.OnlyTest;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.Model;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public interface OutStore {
    public SegmentWriter createSegment(String var1);

    public SegmentWriter createSegment(String var1, int var2);

    public SegmentWriter createSegment(String var1, String var2);

    public SegmentWriter createSegment(String var1, int var2, String var3);

    public SegmentWriter cloneSegmentExcludeRowData(String var1, String var2);

    @OnlyPrivate
    public void commit();

    @OnlyPrivate
    public void close();

    @OnlyPrivate
    public Segment segment(Segment.SD var1);

    @OnlyPrivate
    public List<Segment.SD> sdList();

    public CellFile file(byte[] var1, String var2, String var3);

    public LimitLogger limitLogger();

    public Map<String, List<Map<String, Object>>> capture(int var1);

    public void fileName(String var1);

    public GroupOperation group(String var1);

    @OnlyPrivate
    public Stat stat();

    @OnlyPrivate
    public RuntimeStat runtimeStat();

    public FeatureOperation feature();

    public static class RuntimeStatImpl
    implements RuntimeStat {
        private final AtomicInteger rowCount = new AtomicInteger(0);
        private final AtomicInteger segmentCount = new AtomicInteger(0);
        String segment;
        volatile long lastIoTime;
        volatile long byteSize;
        volatile boolean cancelled;
        private final AtomicLong jsonByteSize = new AtomicLong(0L);
        private final AtomicLong compressedByteSize = new AtomicLong(0L);
        private final AtomicLong maxRowRegionByteSize = new AtomicLong(0L);

        @Override
        public void rowCountAdd(int added) {
            this.rowCount.addAndGet(added);
        }

        @Override
        public int rowCount() {
            return this.rowCount.get();
        }

        @Override
        public void segmentAdd(String segment) {
            this.segment = segment;
        }

        @Override
        public String currentSegment() {
            return this.segment;
        }

        @Override
        public int segmentCount() {
            return this.segmentCount.get();
        }

        @Override
        public void segmentCountAdd(int added) {
            this.segmentCount.addAndGet(added);
        }

        @Override
        public long lastIoTimeMs() {
            return this.lastIoTime;
        }

        @Override
        public void lastIoTimeMs(long lastIoTimeMs) {
            this.lastIoTime = lastIoTimeMs;
        }

        @Override
        public void byteSize(long byteSize) {
            this.byteSize = byteSize;
        }

        @Override
        public long byteSize() {
            return this.byteSize;
        }

        @Override
        public boolean cancelled() {
            return this.cancelled;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void compressedByteSizeAdd(long byteSize) {
            this.compressedByteSize.addAndGet(byteSize);
        }

        @Override
        public void jsonByteSizeAdd(long byteSize) {
            this.jsonByteSize.addAndGet(byteSize);
        }

        @Override
        public long jsonByteSize() {
            return this.jsonByteSize.get();
        }

        @Override
        public long compressedByteSize() {
            return this.compressedByteSize.get();
        }

        @Override
        public long maxRowRegionByteSize() {
            return this.maxRowRegionByteSize.get();
        }

        @Override
        public void maxRowRegionByteSize(long maxRowRegionByteSize) {
            this.maxRowRegionByteSize.updateAndGet(operand -> Math.max(operand, maxRowRegionByteSize));
        }
    }

    @OnlyPrivate
    public static interface RuntimeStat {
        public void rowCountAdd(int var1);

        public int rowCount();

        public void segmentAdd(String var1);

        public String currentSegment();

        public int segmentCount();

        public void segmentCountAdd(int var1);

        public long lastIoTimeMs();

        public void lastIoTimeMs(long var1);

        public void byteSize(long var1);

        public long byteSize();

        public boolean cancelled();

        public void cancel();

        public long jsonByteSize();

        public void jsonByteSizeAdd(long var1);

        public long compressedByteSize();

        public void compressedByteSizeAdd(long var1);

        public long maxRowRegionByteSize();

        public void maxRowRegionByteSize(long var1);
    }

    public static class SegmentStat
    implements Model {
        private int rowCount;

        public int getRowCount() {
            return this.rowCount;
        }

        public void setRowCount(int rowCount) {
            this.rowCount = rowCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentStat)) {
                return false;
            }
            SegmentStat other = (SegmentStat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getRowCount() == other.getRowCount();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SegmentStat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRowCount();
            return result;
        }

        public String toString() {
            return "OutStore.SegmentStat(rowCount=" + this.getRowCount() + ")";
        }
    }

    public static class Stat
    implements Model {
        private List<SegmentStat> segmentStatList;

        public List<SegmentStat> getSegmentStatList() {
            return this.segmentStatList;
        }

        public void setSegmentStatList(List<SegmentStat> segmentStatList) {
            this.segmentStatList = segmentStatList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Stat)) {
                return false;
            }
            Stat other = (Stat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<SegmentStat> this$segmentStatList = this.getSegmentStatList();
            List<SegmentStat> other$segmentStatList = other.getSegmentStatList();
            return !(this$segmentStatList == null ? other$segmentStatList != null : !((Object)this$segmentStatList).equals(other$segmentStatList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Stat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<SegmentStat> $segmentStatList = this.getSegmentStatList();
            result = result * 59 + ($segmentStatList == null ? 43 : ((Object)$segmentStatList).hashCode());
            return result;
        }

        public String toString() {
            return "OutStore.Stat(segmentStatList=" + this.getSegmentStatList() + ")";
        }
    }

    public static class Feature
    implements Model {
        private boolean rangeMerge;
        private boolean border;
        @OnlyTest
        private boolean parallelism;

        public boolean isRangeMerge() {
            return this.rangeMerge;
        }

        public boolean isBorder() {
            return this.border;
        }

        public boolean isParallelism() {
            return this.parallelism;
        }

        public void setRangeMerge(boolean rangeMerge) {
            this.rangeMerge = rangeMerge;
        }

        public void setBorder(boolean border) {
            this.border = border;
        }

        public void setParallelism(boolean parallelism) {
            this.parallelism = parallelism;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Feature)) {
                return false;
            }
            Feature other = (Feature)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRangeMerge() != other.isRangeMerge()) {
                return false;
            }
            if (this.isBorder() != other.isBorder()) {
                return false;
            }
            return this.isParallelism() == other.isParallelism();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Feature;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRangeMerge() ? 79 : 97);
            result = result * 59 + (this.isBorder() ? 79 : 97);
            result = result * 59 + (this.isParallelism() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "OutStore.Feature(rangeMerge=" + this.isRangeMerge() + ", border=" + this.isBorder() + ", parallelism=" + this.isParallelism() + ")";
        }
    }

    public static class Group
    implements Model {
        private String fileName;

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Group)) {
                return false;
            }
            Group other = (Group)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            return !(this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Group;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            return result;
        }

        public String toString() {
            return "OutStore.Group(fileName=" + this.getFileName() + ")";
        }
    }

    public static interface FeatureOperation {
        public void supportRangeMerge(boolean var1);

        public void supportBorder(boolean var1);

        @OnlyTest
        public void supportParallelism(boolean var1);
    }

    public static interface GroupOperation {
        public void fileName(String var1);
    }

    public static interface SegmentWriter {
        public void append(Map<String, Object> var1);

        public void append(List<Map<String, Object>> var1);

        public void append(Model var1);

        public void meta(Map<String, Object> var1);

        public void commit();

        public Segment.Title title();

        public Segment.Header header();

        public String group();

        public FeatureOperation feature();

        public List<Map<String, Object>> capture(int var1);

        public static interface FeatureOperation {
            public void supportRangeMerge(boolean var1);

            public void supportBorder(boolean var1);
        }
    }
}

