package com.ovopark.iohub.sdk.client.outstream;

import java.util.ArrayList;
import java.util.List;

final public class RenderJobManager {

    final static private List<RenderJobFactoryProxy> renderJobFactoryProxyList =new ArrayList<>();

    public static RenderJob newJob(){
        return newJob(false);
    }

    public static RenderJob newJob(boolean nfs){
        return nfs? newJob("/iohub-render-job/export/defaultNfsRenderJob"): newJob("/iohub-render-job/export/defaultMemoryRenderJob");
    }

    public static RenderJob newJob(String uri){
        for (RenderJobFactoryProxy renderJobFactory : renderJobFactoryProxyList) {
            RenderJob renderJob = renderJobFactory.newJob(uri);
            if (renderJob!=null) {
                return renderJob;
            }
        }
        return null;
    }

    public static RenderJobFactoryProxy use(RenderJobFactory renderJobFactory){
        return new RenderJobFactoryProxyImpl(renderJobFactory);
    }

    public synchronized static void register(RenderJobFactory renderJobFactory){
        renderJobFactoryProxyList.add(new RenderJobFactoryProxyImpl(renderJobFactory));
    }


    public interface RenderJobFactory{

        RenderJob factory(String uri);
    }

    static private class RenderJobFactoryProxyImpl implements RenderJobFactoryProxy{

        final private RenderJobFactory renderJobFactory;

        public RenderJobFactoryProxyImpl(RenderJobFactory renderJobFactory) {
            this.renderJobFactory = renderJobFactory;
        }

        public RenderJob newJob(String uri){
            return renderJobFactory.factory(uri);
        }

    }

    public interface RenderJobFactoryProxy{

        default RenderJob newJob(){
            return newJob(false);
        }

        default RenderJob newJob(boolean nfs){
            return nfs? newJob("/iohub-render-job/export/defaultNfsRenderJob"): newJob("/iohub-render-job/export/defaultMemoryRenderJob");
        }

        RenderJob newJob(String uri);
    }
}
