package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public interface OutStore {

    SegmentWriter createSegment(String name);

    SegmentWriter createSegment(String name,int rowSize);

    SegmentWriter createSegment(String name,String group);

    SegmentWriter createSegment(String name,int rowSize,String group);

    SegmentWriter cloneSegmentExcludeRowData(String name, String target);

    @OnlyPrivate
    void commit();

    @OnlyPrivate
    void close();

    @OnlyPrivate
    Segment segment(Segment.SD sd);

    @OnlyPrivate
    List<Segment.SD> sdList();

    CellFile file(byte[] data, String name, String type);

    /**
     * <PRE>
     * 这个日志可以把内容推送到control， 最大只能推送 1W 次，
     * 尽量在关键性的节点打印日志
     *
     * 日志也会通过Slf4j打印 , info级别
     *
     * 支持并发
     * @return
     */
    LimitLogger limitLogger();

    Map<String,List<Map<String,Object>>> capture(int n);

    interface SegmentWriter{

        void append(Map<String,Object> data);

        void append(List<Map<String,Object>> data);

        void append(Model model);

        void meta(Map<String,Object> meta);

        void commit();

        Segment.Title title();

        Segment.Header header();

        String group();

        FeatureOperation feature();

        List<Map<String,Object>> capture(int n);

        interface FeatureOperation {

            void supportRangeMerge(boolean rangeMerge);

            void supportBorder(boolean border);

        }

    }

    void fileName(String fileName);

    GroupOperation group(String group);

    @OnlyPrivate
    Stat stat();

    @OnlyPrivate
    RuntimeStat runtimeStat();

    FeatureOperation feature();

    interface GroupOperation{

        void fileName(String fileName);


    }

    interface FeatureOperation {

        void supportRangeMerge(boolean rangeMerge);

        void supportBorder(boolean border);

        @OnlyTest
        void supportParallelism(boolean parallelism);
    }

    @Data
    class Group implements Model{

        private String fileName;

    }

    @Data
    class Feature implements Model{

        private boolean rangeMerge;

        private boolean border;

        @OnlyTest
        private boolean parallelism;

    }

    @Data
    class Stat implements Model{

        private List<SegmentStat> segmentStatList;

    }

    @Data
    class SegmentStat implements Model{

        private int rowCount;



    }


    @OnlyPrivate
    interface RuntimeStat{

        void rowCountAdd(int added);

        int rowCount();

        void segmentAdd(String segment);

        String currentSegment();

        int segmentCount();

        void segmentCountAdd(int added);

        long lastIoTimeMs();

        void lastIoTimeMs(long lastIoTimeMs);

        void byteSize(long byteSize);

        long byteSize();

        boolean cancelled();

        void cancel();

        long jsonByteSize();

        void jsonByteSizeAdd(long byteSize);

        long compressedByteSize();

        void compressedByteSizeAdd(long byteSize);

        long maxRowRegionByteSize();

        void maxRowRegionByteSize(long maxRowRegionByteSize);


    }

    class RuntimeStatImpl implements RuntimeStat{

        final private AtomicInteger rowCount=new AtomicInteger(0);

        final private AtomicInteger segmentCount=new AtomicInteger(0);

        String segment;

        volatile long lastIoTime;

        volatile long byteSize;

        volatile boolean cancelled;

        final private AtomicLong jsonByteSize=new AtomicLong(0);

        final private AtomicLong compressedByteSize=new AtomicLong(0);

        final private AtomicLong maxRowRegionByteSize=new AtomicLong(0);

        @Override
        public void rowCountAdd(int added) {
            rowCount.addAndGet(added);
        }

        @Override
        public int rowCount() {
            return rowCount.get();
        }

        @Override
        public void segmentAdd(String segment) {
            this.segment=segment;
        }

        @Override
        public String currentSegment() {
            return segment;
        }

        @Override
        public int segmentCount() {
            return segmentCount.get();
        }

        @Override
        public void segmentCountAdd(int added) {
            segmentCount.addAndGet(added);
        }

        @Override
        public long lastIoTimeMs() {
            return lastIoTime;
        }

        @Override
        public void lastIoTimeMs(long lastIoTimeMs) {
            this.lastIoTime= lastIoTimeMs;
        }

        @Override
        public void byteSize(long byteSize) {
            this.byteSize=byteSize;
        }

        @Override
        public long byteSize() {
            return byteSize;
        }

        @Override
        public boolean cancelled() {
            return cancelled;
        }

        @Override
        public void cancel() {
            this.cancelled=true;
        }

        @Override
        public void compressedByteSizeAdd(long byteSize) {
            compressedByteSize.addAndGet(byteSize);
        }

        @Override
        public void jsonByteSizeAdd(long byteSize) {
            jsonByteSize.addAndGet(byteSize);
        }

        @Override
        public long jsonByteSize() {
            return jsonByteSize.get();
        }

        @Override
        public long compressedByteSize() {
            return compressedByteSize.get();
        }

        @Override
        public long maxRowRegionByteSize() {
            return maxRowRegionByteSize.get();
        }

        @Override
        public void maxRowRegionByteSize(long maxRowRegionByteSize) {
            this.maxRowRegionByteSize.updateAndGet(operand -> Math.max(operand,maxRowRegionByteSize));
        }
    }


}
