package com.ovopark.iohub.sdk.model.proto.internal;

import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.util.Map;

@Data
public class NFSSegmentModel implements Model , SegmentRuntimeStatGetter {

    private String name;

    private String url;

    private Map<String,Object> meta;

    private TitleImpl title;

    private HeaderImpl header;

    /**
     * same group , i.e. in same excel file , xlsx
     *   group1        group2         group3
     *   /    \         /    \          /   \
     * sheet  sheet    ...           ...
     *
     */
    private String group;

    private int rowCount;

    private Segment.Feature feature;

    private SegmentRuntimeStatImpl segmentRuntimeStat;

    @Override
    public SegmentRuntimeStat segmentRuntimeStat() {
        return segmentRuntimeStat;
    }
}
