package com.ovopark.iohub.sdk.model.proto.internal;

import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.vfile.AppendLog;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;

import static com.ovopark.kernel.shared.Util.decompress;

public class SegmentFileReader implements Closeable {

    private final AppendLog appendLog;

    public SegmentFileReader(String path) {
        this.appendLog =new AppendLog.AppendLogFileImpl("segment", path);
    }

    final public long fileByteSize(){
        return new File(appendLog.filePath()).length();
    }

    public final synchronized void scan(RowDataListener rowDataListener) throws IOException {
        appendLog.scan((bytes, i, i1) -> {
            Segment.RowRegion rowRegion;
            if (appendLog.compressed()) {
                rowRegion=JSONAccessor.impl().read(decompress(bytes,i,i1), Segment.RowRegion.class);
            }
            else {
                rowRegion=JSONAccessor.impl().read(bytes, i, i1, Segment.RowRegion.class);
            }
            for (Map<String, Object> row : rowRegion.getDataList()) {
                rowDataListener.onRow(row);
            }
        });
    }

    @Override
    public void close() throws IOException {
        appendLog.close();
    }

    public interface RowDataListener {

        void onRow(Map<String,Object> row);

    }

}
