package com.ovopark.iohub.sdk.model.proto.internal;

import com.ovopark.iohub.sdk.model.proto.OnlyTest;
import com.ovopark.kernel.shared.Model;
import lombok.Data;

@Data
public class JobHint implements Model {

    private int regionRowCount;

    private int waitRenderTimeMinute;

    private int blockRenderTimeSecond;

    private String outStore;

    /**
     * import
     */
    private boolean skipHeaderValidate;

    private String clientApp;

    /**
     * @since 4.1
     */
    @OnlyTest
    private int groupParallelism;

    /**
     * @since 4.1
     */
    @OnlyTest
    private int segmentParallelism;


    /**
     * @since 4.13
     */
    @OnlyTest
    private boolean printRowData;

    /**
     * @since 4.15
     */
    @OnlyTest
    private boolean skipUploadExportFile;

    /**
     * export
     * @since 4.15
     */
    @OnlyTest
    private boolean compressed;

    /**
     * only supported for NFS
     * @since 5.1
     */
    @OnlyTest
    private boolean saveNfsStateForTest;

    /**
     * @since 7.6
     */
    private int captureDataNum;

    /**
     * @since 7.9
     */
    private String redirectUri;

    /**
     * @since 7.11
     */
    private int waitReadExcelTimeMinute;

}
