/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.model.proto.internal;

import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.iohub.sdk.model.proto.internal.RowTransLog;
import com.ovopark.iohub.sdk.model.proto.internal.RowTransLogConfig;
import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.vfile.AppendLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedRowTransLogImpl
implements RowTransLog {
    private static final Logger log = LoggerFactory.getLogger(MixedRowTransLogImpl.class);
    private final AppendLog appendLog;
    private Segment.RowRegion rowRegion;
    private final RowTransLogConfig rowTransLogConfig;
    final String filePath;
    private long byteSize;
    final OutStore.RuntimeStat runtimeStat;

    public MixedRowTransLogImpl(String tag, String filePath, RowTransLogConfig rowTransLogConfig, OutStore.RuntimeStat runtimeStat) {
        AppendLog.AppendLogConf appendLogConf = new AppendLog.AppendLogConf();
        appendLogConf.setWalBufferSizeMb(rowTransLogConfig.getWalBufferSizeMb());
        appendLogConf.setWalDiskSizeMb(rowTransLogConfig.getWalDiskSizeMb());
        appendLogConf.setWalIntervalSec(rowTransLogConfig.getWalIntervalSec());
        appendLogConf.setCompressed(rowTransLogConfig.isCompressed());
        this.appendLog = new AppendLog.BufferedAppendLogImpl(tag, filePath, appendLogConf);
        this.rowRegion = new Segment.RowRegion();
        this.rowTransLogConfig = rowTransLogConfig;
        this.filePath = filePath;
        this.runtimeStat = runtimeStat;
    }

    @Override
    public synchronized void append(Map<String, Object> data) {
        this.rowRegion.getDataList().add(data);
        this.fsyncRegion(false);
    }

    private void fsyncRegion(boolean force) {
        List<Map<String, Object>> dataList = this.rowRegion.getDataList();
        if (dataList.size() > this.rowTransLogConfig.getRegionRowCount() || force) {
            try {
                byte[] data = JSONAccessor.impl().formatAsBytes((Object)this.rowRegion);
                this.runtimeStat.maxRowRegionByteSize(data.length);
                this.runtimeStat.jsonByteSizeAdd(data.length);
                if (this.rowTransLogConfig.isCompressed()) {
                    data = Util.compress((byte[])data);
                    this.runtimeStat.compressedByteSizeAdd(data.length);
                }
                long append = this.appendLog.append(data);
                this.byteSize += append;
            }
            catch (Exception e) {
                log.error(this.rowRegion.getDataList().size() + " / " + this.rowTransLogConfig.getRegionRowCount() + " rows, size exceed " + this.rowTransLogConfig.getWalBufferSizeMb() + "MB???? ");
                throw DBOpeException.from((Throwable)e);
            }
            if (this.appendLog.freeSize4G() < 0L) {
                throw new IllegalStateException("error, exceed max file size: " + this.rowTransLogConfig.getWalDiskSizeMb() + " MB, file: " + this.filePath);
            }
            this.rowRegion = new Segment.RowRegion();
        }
    }

    @Override
    public synchronized void append(List<Map<String, Object>> data) {
        this.rowRegion.getDataList().addAll(data);
        this.fsyncRegion(false);
    }

    @Override
    public synchronized void fsync() throws DBOpeException {
        this.fsyncRegion(true);
        this.appendLog.fsync();
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.fsync();
        }
        finally {
            this.appendLog.close();
        }
    }

    @Override
    public long byteSize() {
        return this.byteSize;
    }

    @Override
    public List<Map<String, Object>> capture(int n) {
        List<Map<String, Object>> rowList = this.rowRegion.getDataList();
        int size = rowList.size();
        if (size == 0) {
            return new ArrayList<Map<String, Object>>(0);
        }
        int f = size - n;
        if (f < 0) {
            f = 0;
        }
        ArrayList<Map<String, Object>> captureList = new ArrayList<Map<String, Object>>(Math.min(n, size));
        for (int i = f; i < size; ++i) {
            captureList.add(rowList.get(i));
        }
        return captureList;
    }
}

