package com.ovopark.iohub.sdk.client.instream;

import lombok.Data;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/**
 * @since 4.6
 */
public interface ReadJob {

    ReadFuture readExcel(String file,ReadDef readDef);

    ReadFuture read(String file,ReadDef readDef);

    interface ReadFuture{

        JobInTaskFlow.DataRowStream<?> get() throws InterruptedException,CancellationException, ExecutionException;

        JobInTaskFlow.DataRowStream<?> get(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException, CancellationException,ExecutionException;

        boolean cancelled();

        void cancel();

        void setReadListener(ReadListener readListener);

    }

    interface ReadDef{

        /**
         * sheetIndexList: "0,1"
         */
        String sheetIndexList();

        /**
         * import , start 0
         */
        int headerFromIndex();

        /**
         * import , start 0
         */
        int headerToIndex();

        /**
         * headerMaxColumnIndexList: "6,9"
         */
        String headerMaxColumnIndexList();

        /**
         * import, start 0
         */
        int dataStartRowIndex();

        static ReadDefBuilder builder(){
            return new ReadDefBuilder();
        }

        final class ReadDefBuilder{

            final private ReadDefImpl readDef=new ReadDefImpl();

            public ReadDefBuilder sheetIndexList(String sheetIndexList){
                readDef.setSheetIndexList(sheetIndexList);
                return this;
            }


            public ReadDefBuilder headerFromIndex(int headerFromIndex){
                readDef.setHeaderToIndex(headerFromIndex);
                return this;
            }


            public ReadDefBuilder headerToIndex(int headerToIndex){
                readDef.setHeaderToIndex(headerToIndex);
                return this;
            }

            public ReadDefBuilder headerMaxColumnIndexList(String headerMaxColumnIndexList){
                readDef.setHeaderMaxColumnIndexList(headerMaxColumnIndexList);
                return this;
            }

            public ReadDefBuilder dataStartRowIndex(int dataStartRowIndex){
                readDef.setDataStartRowIndex(dataStartRowIndex);
                return this;
            }

            public ReadDef build(){
                return readDef;
            }

            @Data
            private class ReadDefImpl implements ReadDef{
                String sheetIndexList;
                int headerFromIndex;
                int headerToIndex;
                String headerMaxColumnIndexList;
                int dataStartRowIndex;

                @Override
                public String sheetIndexList() {
                    return sheetIndexList;
                }

                @Override
                public int headerFromIndex() {
                    return headerFromIndex;
                }

                @Override
                public int headerToIndex() {
                    return headerToIndex;
                }

                @Override
                public String headerMaxColumnIndexList() {
                    return headerMaxColumnIndexList;
                }

                @Override
                public int dataStartRowIndex() {
                    return dataStartRowIndex;
                }
            }
        }



    }


    interface ReadListener{

        /**
         * <PRE>
         * 错误包含:
         * 1. {@link CancellationException}
         * 2. {@link RuntimeException}
         * @param dataRowStream 文件地址
         * @param t 渲染错误
         */
        void onRead(JobInTaskFlow.DataRowStream<?> dataRowStream, Throwable t);

    }


}
