package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.model.proto.OnlyTest;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.iohub.sdk.model.proto.internal.JobHint;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public interface RenderJob {


    OutStore outStore();

    RenderFuture render2Excel();

    RenderFuture render();

    /**
     * @since 4.15
     * @param jobHint
     * @return
     */
    @OnlyTest
    RenderFuture render4Test(JobHint jobHint);

    interface RenderFuture{

        String get() throws InterruptedException,CancellationException, ExecutionException;

        String get(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException, CancellationException,ExecutionException;

        boolean cancelled();

        void cancel();

        void setRenderListener(RenderListener renderListener);

    }


    interface RenderListener{

        /**
         * <PRE>
         * 错误包含:
         * 1. {@link CancellationException}
         * 2. {@link RuntimeException}
         * @param outFileUrl 文件地址
         * @param t 渲染错误
         */
        void onRender(String outFileUrl, Throwable t);

    }


}
