package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.iohub.sdk.model.proto.internal.SegmentRuntimeStat;
import com.ovopark.iohub.sdk.model.proto.internal.SegmentRuntimeStatGetter;
import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.ovopark.kernel.shared.Util.convert2RuntimeException;

public interface Segment extends SegmentRuntimeStatGetter {

    List<Map<String,Object>> rowList();

    int size();

    void append(Map<String,Object> row);

    String name();

    Map<String,Object> meta();

    Title title();

    Header header();

    String group();

    void commit();

    Feature feature();

    @OnlyPrivate
    List<Map<String,Object>> capture(int n);

    @Data
    class SD{

        private String group;

        private String name;

        private boolean memory;

        private String url;

        private Map<String,Object> meta;

        private int rowCount;

    }

    interface Header{

        void maxPossibleHeadIndex(int maxPossibleHeadIndex);

        int maxPossibleHeadIndex();

        int maxHeadIndex();

        HeaderFeatureOperation root(String property);

        void root(List<String> propertyList);

        void children(String path,List<String> propertyList);

        HeaderFeatureOperation children(String path,String property);

        HeaderFeatureOperation children(String path,String property,Width width);

        HeaderFeatureOperation children(String path,String property,Width width,I18n i18n);

        HeaderFeatureOperation children(String path,String property,Width width,I18n i18n,CellType cellType);

        void all(Class<? extends Model> clazz);

        void all(Class<? extends Model> clazz, I18n i18n);

        HeaderFeatureOperation upset(String path,String property,Width width);

        HeaderFeatureOperation upset(String path,String property,Width width,I18n i18n);

        HeaderFeatureOperation upset(String path,String property,Width width,I18n i18n,CellType cellType);

        void upsetAsVirtual(String path,String property);

        void updateAsVirtual(String path);

        void defaultColumnWidth(int width);

        int defaultColumnWidth();

        int height();

        int heightExcludeVirtual();

        @OnlyPrivate
        void commit();

        @OnlyPrivate
        void fixed();

        void i18n(Header.I18n i18n);

        void width(Header.Width width);

        Cell cell(String path);

        boolean delete(String path,String property);

        void printPretty(OutputStream outputStream);

        void printPretty();

        interface I18n{

            String i18n(String path);

        }

        interface Width{
            int width(String path);
        }

        interface CellType{
            CellDataType cellType(String path);
        }

        void scanUp2Down(Scan scan);

        interface Scan{

            void scan(Cell cell);

        }

        List<String> properties();

        List<String> leafProperties();

        HeaderFeatureOperation headerFeature(String path);

        interface Cell{

            int level();

            String path();

            String[] pathLink();

            String property();

            String name();

            List<? extends Cell> cellList();

            int leafCount();

            int position();

            int width();

            int excelX();
            
            int excelY();

            CellDataType cellType();

            boolean virtual();

            @OnlyPrivate
            Segment.HeaderFeature feature();

            /**
             * @since 6.11
             */
            @OnlyPrivate
            Segment.HeaderPartFeature headerPartFeature();

        }

    }

    interface Title{

        void title(String title);

        String title();

    }

    @Data
    class RowRegion{

        private List<Map<String,Object>> dataList=new ArrayList<>();

    }

    @Data
    class Feature implements Model{

        private boolean rangeMerge;

        private boolean border;

        private String defaultValIfNullOrEmpty;

    }

    @Data
    class HeaderPartFeature extends HeaderFeature{

        private boolean enabled;

    }

    @Data
    class HeaderFeature implements Model{

        private boolean fontFeatureEnabled;

        private boolean bold;

        private boolean underline;

        private boolean italic;

        private boolean strikeout;

        private String color;

        private boolean hyperlinkFeatureEnabled;

        private boolean hyperlinkUrl;

        /**
         * @since 3.26
         */
        private boolean textFeatureEnabled;

        private boolean textWrapped;

        private String horizontalAlignment;

        private String verticalAlignment;


        /**
         * @since 4.1
         */
        private boolean mergeEnabled;

        /**
         * @since 4.1
         */
        private boolean verticalMerge;

        /**
         * @since 6.11
         */
        private boolean foregroundFeatureEnabled;

        /**
         * @since 6.11
         */
        private String foregroundColor;

        /**
         * @since 7.31
         */
        private boolean defaultValIfNullOrEmptyEnabled;

        private String defaultValIfNullOrEmpty;

        public HeaderFeature clone(){
            try {
                return (HeaderFeature) super.clone();
            } catch (CloneNotSupportedException e) {
                throw convert2RuntimeException(e);
            }
        }

    }

    interface HeaderFeatureOperation {

        HeaderFeatureOperation fontBold(boolean bold);

        HeaderFeatureOperation fontUnderline(boolean underline);

        HeaderFeatureOperation fontItalic(boolean italic);

        HeaderFeatureOperation fontStrikeout(boolean strikeout);

        HeaderFeatureOperation fontColor(String color);

        /**
         *
         * @param type url
         * @return
         */
        HeaderFeatureOperation hyperlink(String type);

        HeaderFeatureOperation textWrapped(boolean textWrapped);

        HeaderFeatureOperation horizontalAlignment(HorizontalAlignment horizontalAlignment);

        HeaderFeatureOperation verticalAlignment(VerticalAlignment verticalAlignment);

        HeaderFeatureOperation verticalMerge(boolean verticalMerge);

        /**
         * @since 7.31
         * @param val
         * @return
         */
        HeaderFeatureOperation defaultValIfNullOrEmpty(String val);
    }

    @OnlyPrivate
    @Override
    default SegmentRuntimeStat segmentRuntimeStat(){return null;}
}
