/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client.instream;

import com.ovopark.iohub.sdk.client.instream.ReadJob;
import java.util.ArrayList;
import java.util.List;

public final class ReadJobManager {
    private static final List<ReadJobFactoryProxy> readJobFactoryProxyList = new ArrayList<ReadJobFactoryProxy>();

    public static ReadJob newJob() {
        return ReadJobManager.newJob(false);
    }

    public static ReadJob newJob(boolean nfs) {
        return nfs ? ReadJobManager.newJob("/iohub-read-job/import/defaultNfsReadJob") : ReadJobManager.newJob("/iohub-read-job/import/defaultMemoryReadJob");
    }

    public static ReadJob newJob(String uri) {
        for (ReadJobFactoryProxy renderJobFactory : readJobFactoryProxyList) {
            ReadJob renderJob = renderJobFactory.newJob(uri);
            if (renderJob == null) continue;
            return renderJob;
        }
        return null;
    }

    public static ReadJobFactoryProxy use(ReadJobFactory renderJobFactory) {
        return new ReadJobFactoryProxyImpl(renderJobFactory);
    }

    public static synchronized void register(ReadJobFactory readJobFactory) {
        readJobFactoryProxyList.add(new ReadJobFactoryProxyImpl(readJobFactory));
    }

    public static interface ReadJobFactoryProxy {
        default public ReadJob newJob() {
            return this.newJob(false);
        }

        default public ReadJob newJob(boolean nfs) {
            return nfs ? this.newJob("/iohub-read-job/import/defaultNfsReadJob") : this.newJob("/iohub-read-job/import/defaultMemoryReadJob");
        }

        public ReadJob newJob(String var1);
    }

    private static class ReadJobFactoryProxyImpl
    implements ReadJobFactoryProxy {
        private final ReadJobFactory readJobFactory;

        public ReadJobFactoryProxyImpl(ReadJobFactory readJobFactory) {
            this.readJobFactory = readJobFactory;
        }

        @Override
        public ReadJob newJob(String uri) {
            return this.readJobFactory.factory(uri);
        }
    }

    public static interface ReadJobFactory {
        public ReadJob factory(String var1);
    }
}

