/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.client.outstream.RenderJob;
import java.util.ArrayList;
import java.util.List;

public final class RenderJobManager {
    private static final List<RenderJobFactoryProxy> renderJobFactoryProxyList = new ArrayList<RenderJobFactoryProxy>();

    public static RenderJob newJob() {
        return RenderJobManager.newJob(false);
    }

    public static RenderJob newJob(boolean nfs) {
        return nfs ? RenderJobManager.newJob("/iohub-render-job/export/defaultNfsRenderJob") : RenderJobManager.newJob("/iohub-render-job/export/defaultMemoryRenderJob");
    }

    public static RenderJob newJob(String uri) {
        for (RenderJobFactoryProxy renderJobFactory : renderJobFactoryProxyList) {
            RenderJob renderJob = renderJobFactory.newJob(uri);
            if (renderJob == null) continue;
            return renderJob;
        }
        return null;
    }

    public static RenderJobFactoryProxy use(RenderJobFactory renderJobFactory) {
        return new RenderJobFactoryProxyImpl(renderJobFactory);
    }

    public static synchronized void register(RenderJobFactory renderJobFactory) {
        renderJobFactoryProxyList.add(new RenderJobFactoryProxyImpl(renderJobFactory));
    }

    public static interface RenderJobFactoryProxy {
        default public RenderJob newJob() {
            return this.newJob(false);
        }

        default public RenderJob newJob(boolean nfs) {
            return nfs ? this.newJob("/iohub-render-job/export/defaultNfsRenderJob") : this.newJob("/iohub-render-job/export/defaultMemoryRenderJob");
        }

        public RenderJob newJob(String var1);
    }

    private static class RenderJobFactoryProxyImpl
    implements RenderJobFactoryProxy {
        private final RenderJobFactory renderJobFactory;

        public RenderJobFactoryProxyImpl(RenderJobFactory renderJobFactory) {
            this.renderJobFactory = renderJobFactory;
        }

        @Override
        public RenderJob newJob(String uri) {
            return this.renderJobFactory.factory(uri);
        }
    }

    public static interface RenderJobFactory {
        public RenderJob factory(String var1);
    }
}

