/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.model.proto.internal;

import com.ovopark.iohub.sdk.model.proto.CellFile;
import com.ovopark.iohub.sdk.model.proto.LimitLogger;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.iohub.sdk.model.proto.internal.CellFileImpl;
import com.ovopark.iohub.sdk.model.proto.internal.HeaderCellImpl;
import com.ovopark.iohub.sdk.model.proto.internal.SegmentImpl;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;

public class InMemoryOutStore
implements OutStore,
LimitLogger.LimitLoggerSetter {
    private String fileName;
    private final List<Segment> segmentList;
    private boolean committed;
    final OutStore.Stat stat = new OutStore.Stat();
    final OutStore.RuntimeStat runtimeStat = new OutStore.RuntimeStatImpl();
    private final OutStore.Feature feature = new OutStore.Feature();
    private final Map<String, OutStore.Group> groupMap = new HashMap<String, OutStore.Group>();
    LimitLogger limitLogger;
    final int maxRowCountInMemory;

    public InMemoryOutStore(int size) {
        this(size, 10000);
    }

    public InMemoryOutStore(int size, int maxRowCountInMemory) {
        this.segmentList = new ArrayList<Segment>(size);
        this.maxRowCountInMemory = maxRowCountInMemory;
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name) {
        return this.createSegment(name, 10);
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name, int rowSize) {
        return this.createSegment(name, rowSize, "default");
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name, String group) {
        return this.createSegment(name, 10, group);
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name, int rowSize, String group) {
        this.check();
        if (Util.isEmpty((CharSequence)group)) {
            throw new IllegalArgumentException("group is empty");
        }
        this.groupMap.putIfAbsent(group, new OutStore.Group());
        SegmentWriterImpl segmentWriter = new SegmentWriterImpl(name, rowSize, group);
        this.runtimeStat.segmentAdd(group + ":" + name);
        this.runtimeStat.segmentCountAdd(1);
        this.limitLogger.log("create segment " + group + ":" + name);
        return segmentWriter;
    }

    @Override
    public OutStore.SegmentWriter cloneSegmentExcludeRowData(String name, String target) {
        Segment sf = null;
        for (Segment segment : this.segmentList) {
            if (!segment.name().equals(name)) continue;
            sf = segment;
            break;
        }
        if (sf == null) {
            throw new IllegalArgumentException("cannot find segment: " + name);
        }
        SegmentImpl sfi = (SegmentImpl)sf;
        OutStore.SegmentWriter segmentWriter = this.createSegment(target, 8, sfi.getGroup());
        final Segment.Header targetHeader = segmentWriter.header();
        sfi.header().scanUp2Down(new Segment.Header.Scan(){

            @Override
            public void scan(Segment.Header.Cell cell) {
                String p = cell.path();
                if (p.contains(".")) {
                    targetHeader.upset(p.substring(0, p.lastIndexOf(".")), p.substring(p.lastIndexOf(".")), null);
                } else {
                    targetHeader.upset(null, p, null);
                }
                HeaderCellImpl c = (HeaderCellImpl)cell;
                HeaderCellImpl targetCell = (HeaderCellImpl)targetHeader.cell(p);
                targetCell.setWidth(c.getWidth());
                targetCell.setI18Key(c.getI18Key());
                targetCell.setName(c.getName());
                targetCell.setTip(c.getTip());
                targetCell.setVirtual(c.isVirtual());
                Segment.HeaderFeature feature1 = c.feature();
                if (feature1 != null) {
                    Segment.HeaderFeature headerFeature = feature1.clone();
                    targetCell.setHeaderFeature(headerFeature);
                }
            }
        });
        segmentWriter.title().title(sfi.title().title());
        return segmentWriter;
    }

    @Override
    public void commit() {
        this.committed = true;
    }

    @Override
    public void close() {
        for (Segment segment : this.segmentList) {
            segment.commit();
        }
    }

    @Override
    public Segment segment(Segment.SD sd) {
        for (Segment segment : this.segmentList) {
            if (!segment.name().equals(sd.getName()) || !segment.group().equals(sd.getGroup())) continue;
            return segment;
        }
        return null;
    }

    @Override
    public void fileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public OutStore.GroupOperation group(final String group) {
        return new OutStore.GroupOperation(){

            @Override
            public void fileName(String fileName) {
                ((OutStore.Group)InMemoryOutStore.this.groupMap.get(group)).setFileName(fileName);
            }
        };
    }

    @Override
    public OutStore.FeatureOperation feature() {
        return new OutStore.FeatureOperation(){

            @Override
            public void supportRangeMerge(boolean rangeMerge) {
                InMemoryOutStore.this.feature.setRangeMerge(rangeMerge);
            }

            @Override
            public void supportBorder(boolean border) {
                InMemoryOutStore.this.feature.setBorder(border);
            }

            @Override
            public void supportParallelism(boolean parallelism) {
                InMemoryOutStore.this.feature.setParallelism(parallelism);
            }
        };
    }

    @Override
    public OutStore.Stat stat() {
        return this.stat;
    }

    @Override
    public OutStore.RuntimeStat runtimeStat() {
        return this.runtimeStat;
    }

    @Override
    public List<Segment.SD> sdList() {
        ArrayList<Segment.SD> sdList = new ArrayList<Segment.SD>(this.segmentList.size());
        for (Segment segment : this.segmentList) {
            Segment.SD sd = new Segment.SD();
            sd.setMemory(true);
            sd.setName(segment.name());
            sd.setGroup(segment.group());
            sdList.add(sd);
        }
        return sdList;
    }

    @Override
    public CellFile file(byte[] data, String name, String type) {
        CellFileImpl cellFile = new CellFileImpl();
        cellFile.setName(name);
        cellFile.setType(type);
        cellFile.setBase64(true);
        cellFile.setUri(Base64.getEncoder().encodeToString(data));
        return cellFile;
    }

    @Override
    public LimitLogger limitLogger() {
        return this.limitLogger;
    }

    @Override
    public Map<String, List<Map<String, Object>>> capture(int n) {
        LinkedHashMap<String, List<Map<String, Object>>> listMap = new LinkedHashMap<String, List<Map<String, Object>>>();
        int size = this.segmentList.size();
        for (int i = 0; i < size; ++i) {
            Segment segment = this.segmentList.get(i);
            List<Map<String, Object>> list = segment.capture(n);
            listMap.put(segment.name(), list);
        }
        return listMap;
    }

    private void check() {
        if (this.committed) {
            throw new UnsupportedOperationException("all committed???");
        }
    }

    @Override
    public void setLimitLogger(LimitLogger limitLogger) {
        this.limitLogger = limitLogger;
    }

    public String getFileName() {
        return this.fileName;
    }

    public OutStore.Feature getFeature() {
        return this.feature;
    }

    public Map<String, OutStore.Group> getGroupMap() {
        return this.groupMap;
    }

    private class SegmentWriterImpl
    implements OutStore.SegmentWriter {
        private final SegmentImpl segment;
        private boolean committed;
        private final OutStore.SegmentStat segmentStat = new OutStore.SegmentStat();

        public SegmentWriterImpl(String name, int size, String group) {
            this.segment = new SegmentImpl(name, size, group);
        }

        @Override
        public synchronized void append(Map<String, Object> data) {
            this.check();
            this.segment.append(data);
            InMemoryOutStore.this.runtimeStat.rowCountAdd(1);
            InMemoryOutStore.this.runtimeStat.lastIoTimeMs(System.currentTimeMillis());
            if (this.segment.size() > InMemoryOutStore.this.maxRowCountInMemory) {
                throw new IllegalStateException("too many row: " + this.segment.size() + ", max: " + InMemoryOutStore.this.maxRowCountInMemory);
            }
        }

        @Override
        public synchronized void append(List<Map<String, Object>> data) {
            this.check();
            for (Map<String, Object> datum : data) {
                this.segment.append(datum);
            }
            InMemoryOutStore.this.runtimeStat.rowCountAdd(data.size());
            InMemoryOutStore.this.runtimeStat.lastIoTimeMs(System.currentTimeMillis());
            if (this.segment.size() > InMemoryOutStore.this.maxRowCountInMemory) {
                throw new IllegalStateException("too many row: " + this.segment.size() + ", max: " + InMemoryOutStore.this.maxRowCountInMemory);
            }
        }

        @Override
        public void meta(Map<String, Object> meta) {
            this.segment.setMeta(meta);
        }

        @Override
        public synchronized void append(Model model) {
            this.append(JSONAccessor.impl().read(JSONAccessor.impl().format((Object)model)));
        }

        @Override
        public synchronized void commit() {
            if (this.committed) {
                return;
            }
            InMemoryOutStore.this.segmentList.add(this.segment);
            this.segment.header().commit();
            this.segment.commit();
            this.segmentStat.setRowCount(this.segment.getRowList().size());
            if (InMemoryOutStore.this.stat.getSegmentStatList() == null) {
                InMemoryOutStore.this.stat.setSegmentStatList(new ArrayList<OutStore.SegmentStat>());
            }
            InMemoryOutStore.this.stat.getSegmentStatList().add(this.segmentStat);
            this.committed = true;
        }

        @Override
        public Segment.Title title() {
            return this.segment.getTitle();
        }

        private void check() {
            if (this.committed) {
                throw new UnsupportedOperationException("segment committed???");
            }
            if (InMemoryOutStore.this.runtimeStat.cancelled()) {
                throw new CancellationException("task is cancelled");
            }
        }

        @Override
        public Segment.Header header() {
            return this.segment.header();
        }

        @Override
        public String group() {
            return this.segment.group();
        }

        @Override
        public OutStore.SegmentWriter.FeatureOperation feature() {
            return new OutStore.SegmentWriter.FeatureOperation(){

                @Override
                public void supportRangeMerge(boolean rangeMerge) {
                    SegmentWriterImpl.this.segment.feature().setRangeMerge(rangeMerge);
                }

                @Override
                public void supportBorder(boolean border) {
                    SegmentWriterImpl.this.segment.feature().setBorder(border);
                }

                @Override
                public void defaultValIfNullOrEmpty(String val) {
                    SegmentWriterImpl.this.segment.feature().setDefaultValIfNullOrEmpty(val);
                }
            };
        }

        @Override
        public List<Map<String, Object>> capture(int n) {
            return this.segment.capture(n);
        }
    }
}

