/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client.outstream.test;

import com.ovopark.iohub.sdk.client.Client2ControlTransport;
import com.ovopark.iohub.sdk.client.Client2WorkRestClient;
import com.ovopark.iohub.sdk.client.ClientNode;
import com.ovopark.iohub.sdk.client.ClientNodeRegister;
import com.ovopark.iohub.sdk.client.IOHubClientConfig;
import com.ovopark.iohub.sdk.client.JobClientActive;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlow;
import com.ovopark.iohub.sdk.client.outstream.JobOutTaskFlowProvider;
import com.ovopark.iohub.sdk.client.outstream.RequestParamBody;
import com.ovopark.iohub.sdk.client.outstream.test.ExportTaskVo;
import com.ovopark.iohub.sdk.model.AppNode;
import com.ovopark.iohub.sdk.model.outstream.ExportPushCommitRequest;
import com.ovopark.iohub.sdk.model.outstream.ExportPushDataRequest;
import com.ovopark.iohub.sdk.model.outstream.ExportPushDataResponse;
import com.ovopark.iohub.sdk.model.proto.LimitLogger;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.iohub.sdk.model.proto.internal.HeaderImpl;
import com.ovopark.iohub.sdk.model.proto.internal.InMemoryOutStore;
import com.ovopark.iohub.sdk.model.proto.internal.NFSOutStore;
import com.ovopark.iohub.sdk.model.proto.internal.NFSSegmentModel;
import com.ovopark.iohub.sdk.model.proto.internal.SegmentImpl;
import com.ovopark.iohub.sdk.model.proto.internal.TitleImpl;
import com.ovopark.iohub.sdk.model.test.ExportRenderResponse;
import com.ovopark.iohub.sdk.model.test.ExportStartResponse;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.module.shared.Session;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@JobClientActive
@RestController(value="com.ovopark.iohub.sdk.client.outstream.test.ExportLocalTestEndpoint")
@RequestMapping(value={"/feign/iohub-job/processing/only-test/export"})
public class ExportLocalTestEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ExportLocalTestEndpoint.class);
    final String workIp = Config.ConfigPriority.option().getString("iohub.client.io.work.ip", "8.139.4.155");
    final int workPort = Config.ConfigPriority.option().getInt("iohub.client.io.work.port", Integer.valueOf(13950));
    final int maxRowCountInMemory = Config.ConfigPriority.option().getInt("iohub.client.io.work.maxRowCountInMemory", Integer.valueOf(100000));
    @Autowired
    private Client2ControlTransport client2ControlTransport;
    @Autowired
    private IOHubClientConfig ioHubClientConfig;
    @Autowired
    private JobOutTaskFlowProvider jobOutTaskFlowProvider;
    @Autowired
    private ClientNodeRegister.ClientNodeProvider clientNodeProvider;

    @RequestMapping(value={"/submit"})
    public BaseResult<?> submit(@RequestBody ExportTaskVo exportTaskVo, @RequestHeader(value="nfs", required=false) boolean nfs, @RequestHeader(value="ovo-authorization", required=false) String token) {
        ArrayList<NFSSegmentModel> nfsSegmentModelList;
        InMemoryOutStore outStore;
        String uri = exportTaskVo.getUri();
        log.info("uri: " + JSONAccessor.impl().format((Object)uri));
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(45000);
        factory.setConnectTimeout(15000);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        AppNode appNode = new AppNode();
        appNode.setIp(this.workIp);
        appNode.setPort(this.workPort);
        appNode.setServletPath("iohub-work");
        Client2WorkRestClient client2WorkRestClient = new Client2WorkRestClient(appNode, restTemplate);
        ExportStartResponse exportStartResponse = client2WorkRestClient.startOnlyForTest(uri);
        long taskId = exportStartResponse.getTaskId();
        log.info("taskId: " + JSONAccessor.impl().format((Object)exportStartResponse));
        JobOutTaskFlow jobOutTaskFlow = this.jobOutTaskFlowProvider.find(uri);
        jobOutTaskFlow.prepared();
        Session si = Session.getOrCreate().get();
        if (si == null && Util.isNotEmpty((CharSequence)token)) {
            si = client2WorkRestClient.parseSessionOnlyForTest(token);
        }
        RequestParamBody requestParamBody = Util.isEmpty(exportTaskVo.getParamMap()) ? null : jobOutTaskFlow.requestParamBody(JSONAccessor.impl().format(exportTaskVo.getParamMap()), si);
        JobOutTaskFlow.ExportTaskInfoProvider exportTaskInfoProvider = jobOutTaskFlow.exportTaskInfoProvider(requestParamBody, si);
        log.info(" export record , name: " + (exportTaskInfoProvider == null ? null : exportTaskInfoProvider.name()));
        if (nfs) {
            outStore = new NFSOutStore("d:/iohub/client/client-" + ClientNode.UUID_STR + "/local-test/" + Util.uniqueFirstPart(), 1);
            ((NFSOutStore)outStore).setLimitLogger(new LimitLogger(){

                public void log(String content) {
                    log.info(content);
                }
            });
        } else {
            outStore = new InMemoryOutStore(Math.min(1, 10), this.maxRowCountInMemory);
            outStore.setLimitLogger(new LimitLogger(){

                public void log(String content) {
                    log.info(content);
                }
            });
        }
        try {
            jobOutTaskFlow.execute(requestParamBody, (OutStore)outStore);
            outStore.commit();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
        finally {
            outStore.close();
            jobOutTaskFlow.close();
        }
        log.info("execute completed , then we collect all data???");
        List sdList = outStore.sdList();
        if (outStore instanceof NFSOutStore) {
            nfsSegmentModelList = new ArrayList<NFSSegmentModel>();
            for (Segment.SD sd : sdList) {
                NFSSegmentModel nfsSegmentModel = new NFSSegmentModel();
                nfsSegmentModel.setName(sd.getName());
                nfsSegmentModel.setUrl(sd.getUrl());
                nfsSegmentModel.setMeta(sd.getMeta());
                nfsSegmentModel.setRowCount(sd.getRowCount());
                Segment segment = outStore.segment(sd);
                nfsSegmentModel.setTitle((TitleImpl)segment.title());
                nfsSegmentModel.setHeader((HeaderImpl)segment.header());
                nfsSegmentModel.setGroup(segment.group());
                nfsSegmentModelList.add(nfsSegmentModel);
            }
        } else {
            ArrayList<SegmentImpl> list = new ArrayList<SegmentImpl>();
            for (Segment.SD sd : sdList) {
                Segment segment = outStore.segment(sd);
                list.add((SegmentImpl)segment);
            }
            ExportPushDataRequest exportPushDataRequest = new ExportPushDataRequest();
            exportPushDataRequest.setSegmentList(list);
            exportPushDataRequest.setTaskId(taskId);
            exportPushDataRequest.setApp(null);
            exportPushDataRequest.setNode(null);
            exportPushDataRequest.setWorkApp(null);
            exportPushDataRequest.setWorkNode(null);
            ExportPushDataResponse exportPushDataResponse = client2WorkRestClient.pushOnlyForTest(exportPushDataRequest);
            log.info("exportPushDataResponse: " + JSONAccessor.impl().format((Object)exportPushDataResponse));
            if (exportPushDataResponse == null || !exportPushDataResponse.isSuccess()) {
                throw new IllegalStateException("error, push data");
            }
            ExportPushCommitRequest exportPushCommitRequest = new ExportPushCommitRequest();
            exportPushCommitRequest.setFileName(outStore.getFileName());
            exportPushCommitRequest.setTaskId(taskId);
            exportPushCommitRequest.setApp(null);
            exportPushCommitRequest.setNode(null);
            exportPushCommitRequest.setWorkApp(null);
            exportPushCommitRequest.setWorkNode(null);
            exportPushCommitRequest.setGroupMap(outStore.getGroupMap());
            exportPushCommitRequest.setFeature(outStore.getFeature());
            ExportRenderResponse exportRenderResponse = client2WorkRestClient.renderOnlyForTest(exportPushCommitRequest);
            log.info("exportRenderResponse: " + JSONAccessor.impl().format((Object)exportRenderResponse));
            if (exportRenderResponse != null) {
                log.info("file > " + exportRenderResponse.getUrl());
            }
            if (exportRenderResponse == null) {
                throw new IllegalStateException("cannot render excel, file url is null");
            }
            return BaseResult.success((Object)exportRenderResponse);
        }
        ExportPushCommitRequest exportPushCommitRequest = new ExportPushCommitRequest();
        exportPushCommitRequest.setFileName(((NFSOutStore)outStore).getFileName());
        exportPushCommitRequest.setNfsSegmentModelList(nfsSegmentModelList);
        exportPushCommitRequest.setTaskId(0L);
        exportPushCommitRequest.setApp(null);
        exportPushCommitRequest.setNode(null);
        exportPushCommitRequest.setWorkApp(null);
        exportPushCommitRequest.setWorkNode(null);
        exportPushCommitRequest.setGroupMap(((NFSOutStore)outStore).getGroupMap());
        exportPushCommitRequest.setFeature(((NFSOutStore)outStore).getFeature());
        log.info(JSONAccessor.impl().format((Object)exportPushCommitRequest));
        String localFile = this.write2LocalFile(((NFSOutStore)outStore).getPath(), JSONAccessor.impl().format((Object)exportPushCommitRequest));
        log.info("local file: " + localFile);
        log.info("end...");
        return BaseResult.success(null);
    }

    private String write2LocalFile(String path, String nfsMeta) {
        String filePath = path + "/export-" + Util.uniqueFirstPart() + ".nfs";
        log.info("to write data to disk: " + filePath);
        try {
            Util.writeAtomic((File)new File(filePath), (byte[])Util.utf8((String)nfsMeta));
        }
        catch (IOException e) {
            throw Util.convert2RuntimeException((Throwable)e);
        }
        log.info("write data to disk (" + filePath + "), cost time ");
        return filePath;
    }
}

