package com.ovopark.iohub.sdk.client;

import com.ovopark.kernel.shared.NetUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.stereotype.Component;

import java.net.InetAddress;
import java.net.URI;

import static com.ovopark.kernel.shared.Util.isEmpty;
import static com.ovopark.kernel.shared.Util.log;

@JobClientActive
@Component("com.ovopark.iohub.sdk.client.NacosNodeProvider")
public class NacosNodeProvider implements ClientNodeRegister.ClientNodeProvider {


    @Autowired
    private ServiceInstance serviceInstance;

    @Autowired
    private ClientNodeConfig clientNodeConfig;

    @Value("${server.servlet.context-path:}")
    private String contextPath;


    @Value("${spring.application.name}")
    private String app;

    @Override
    public ClientNode clientNode() {
        URI uri = serviceInstance.getUri();
        String registerIp= clientNodeConfig.ip();
        if (isEmpty(registerIp)) {

            if (clientNodeConfig.useNacosIp()) {
                registerIp=uri.getHost();
            }
            else {
                InetAddress localAddress = NetUtil.getLocalAddress();
                registerIp=localAddress.getHostAddress();
            }
        }

        if (isEmpty(registerIp)) {
            log.error("cannot find right IP , exit JVM.");
            Runtime.getRuntime().exit(-1);
        }

        int port;
        if (clientNodeConfig.port()>0) {
            port= clientNodeConfig.port();
        }
        else {
            port=uri.getPort();
        }

        if (port<=0) {
            log.error("cannot find port , exit JVM.");
            Runtime.getRuntime().exit(-1);
        }


        ClientNode.ClientNodeImpl node=new ClientNode.ClientNodeImpl();
//        node.setId(serviceInstance.getServiceId()+":"+ClientNodeRegister.UUID_STR);
        node.setNode(ClientNode.UUID_STR);
        node.setIp(registerIp);
        node.setPort(port);
        node.setServletPath(contextPath);
        node.setApp(app);

        return node;
    }
}
