package com.ovopark.iohub.sdk.client.instream;

import com.ovopark.iohub.sdk.client.*;
import com.ovopark.iohub.sdk.model.JobMeta;
import com.ovopark.iohub.sdk.model.instream.ReadJobStartRequest;
import com.ovopark.iohub.sdk.model.instream.ReadJobStartResponse;
import com.ovopark.iohub.sdk.model.proto.OnlyTest;
import com.ovopark.iohub.sdk.model.proto.internal.JobHint;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.vclient.ClientNode;
import com.ovopark.kernel.shared.vclient.ClientNodeRegister;
import lombok.extern.slf4j.Slf4j;

/**
 * @since 4.6
 */
@OnlyTest
@Slf4j
public class ConfiguredReadJobFactory implements ReadJobManager.ReadJobFactory {

    final private ClientNodeRegister.ClientNodeProvider clientNodeProvider=new LocalClientNodeProvider();

    final private IOHubClientConfig ioHubClientConfig=new IOHubClientConfigImpl();

    final private Client2ControlRestClient client2ControlRestClient;

    final boolean renderJobTest;

    public ConfiguredReadJobFactory(Client2ControlRestClient client2ControlRestClient,boolean renderJobTest) {
        this.client2ControlRestClient = client2ControlRestClient;
        this.renderJobTest=renderJobTest;
    }

    public ConfiguredReadJobFactory(String ip,int uiPort) {
        this.client2ControlRestClient=new Client2ControlRestClient(new ControlNode() {
            @Override
            public String ip() {
                return ip;
            }

            @Override
            public int port() {
                return uiPort();
            }

            @Override
            public int uiPort() {
                return uiPort;
            }
        });
        this.renderJobTest=false;
    }

    @Override
    public ReadJob factory(String uri) {
        ClientNode clientNode = clientNodeProvider.clientNode();

        ReadJobStartRequest readJobStartRequest =new ReadJobStartRequest();
        readJobStartRequest.setUri(uri);
        readJobStartRequest.setClientApp(clientNode.app());
        readJobStartRequest.setClientNode(clientNode.node());


        ReadJobStartResponse readJobStartResponse =
                client2ControlRestClient.startReadJob(readJobStartRequest);
        if (readJobStartResponse ==null || !readJobStartResponse.isSuccess() || readJobStartResponse.getTaskId()==null) {
            throw new IllegalArgumentException("cannot start read job: "+ JSONAccessor.impl().format(readJobStartResponse));
        }

        Long taskId = readJobStartResponse.getTaskId();
        JobMeta jobMeta = readJobStartResponse.getJobMeta();
        JobHint jobHint= readJobStartResponse.getJobHint();

        ReadJobImpl readJob=new ReadJobImpl(taskId,uri,jobMeta.isNfs(),jobMeta,jobHint
                ,ioHubClientConfig,client2ControlRestClient
                , clientNode,renderJobTest);
        return readJob;
    }

}
