package com.ovopark.iohub.sdk.client;

import com.ovopark.kernel.shared.Config;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 * @since 3.8
 */
@Slf4j
@JobClientActive
@Component
public class SpringConfigRegister implements EnvironmentAware , BeanFactoryPostProcessor {

    private Environment environment;

    final private AtomicBoolean flag=new AtomicBoolean(false);

    @Override
    public void setEnvironment(Environment environment) {
        this.environment=environment;
    }


    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (flag.compareAndSet(false,true)) {
            Config.ConfigPriority.option().takeHighPriority(new Config() {
                @Override
                public boolean contains(String key) {
                    return environment.containsProperty(key);
                }

                @Override
                public Object getObject(String key, Object object) {
                    String property = environment.getProperty(key);
                    if (property==null) {
                        return object;
                    }
                    return property;
                }
            });
        }
    }
}
