package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.client.Client2ControlRestClient;
import com.ovopark.iohub.sdk.client.ControlNode;
import com.ovopark.iohub.sdk.model.proto.OnlyTest;
import lombok.extern.slf4j.Slf4j;

/**
 * 支持在main方法里面直接执行任务
 */
@OnlyTest
@Slf4j
public class InstantRenderJobFactory extends ConfiguredRenderJobFactory {
    //test5-47.96.105.39/172.18.87.177
    static final String controlIp= "47.96.105.39";
    static final int controlUiPort= 13900;
    static final private Client2ControlRestClient client2ControlRestClientOnlyForTest;
    static {

        client2ControlRestClientOnlyForTest=new Client2ControlRestClient(new ControlNode() {
            @Override
            public String ip() {
                return controlIp;
            }

            @Override
            public int port() {
                return uiPort();
            }

            @Override
            public int uiPort() {
                return controlUiPort;
            }
        });
    }

    public InstantRenderJobFactory() {
        super(client2ControlRestClientOnlyForTest,true);
    }
}
