/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.client.Client2ControlRestClient;
import com.ovopark.iohub.sdk.client.ClientNodeProvider;
import com.ovopark.iohub.sdk.client.ControlNode;
import com.ovopark.iohub.sdk.client.ControlNodeProxy;
import com.ovopark.iohub.sdk.client.IOHubClientConfig;
import com.ovopark.iohub.sdk.client.JobClientActive;
import com.ovopark.iohub.sdk.client.outstream.RenderJob;
import com.ovopark.iohub.sdk.client.outstream.RenderJobImpl;
import com.ovopark.iohub.sdk.client.outstream.RenderJobManager;
import com.ovopark.iohub.sdk.model.JobMeta;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartRequest;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartResponse;
import com.ovopark.iohub.sdk.model.proto.internal.JobHint;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.vclient.ClientNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@JobClientActive
@Component
public class SpringRenderJobFactory
implements RenderJobManager.RenderJobFactory,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(SpringRenderJobFactory.class);
    final boolean renderJobTest = Config.ConfigPriority.option().getBoolean("iohub.client.renderJob.test", Boolean.valueOf(false));
    final String controlIp = "47.96.105.39";
    final int controlUiPort = 13900;
    private final Client2ControlRestClient client2ControlRestClientOnlyForTest = new Client2ControlRestClient(new ControlNode(){

        @Override
        public String ip() {
            return "47.96.105.39";
        }

        @Override
        public int port() {
            return this.uiPort();
        }

        @Override
        public int uiPort() {
            return 13900;
        }
    });
    @Autowired
    private ClientNodeProvider clientNodeProvider;
    @Autowired
    private IOHubClientConfig ioHubClientConfig;
    private Client2ControlRestClient client2ControlRestClient;

    @Autowired
    public void setControlNodeProxy(final ControlNodeProxy controlNodeProxy) {
        this.client2ControlRestClient = new Client2ControlRestClient(new ControlNode(){

            @Override
            public String ip() {
                return controlNodeProxy.ip();
            }

            @Override
            public int port() {
                return this.uiPort();
            }

            @Override
            public int uiPort() {
                return controlNodeProxy.uiPort();
            }
        });
    }

    public void run(String ... args) throws Exception {
        RenderJobManager.register((RenderJobManager.RenderJobFactory)this);
    }

    public RenderJob factory(String uri) {
        ClientNode clientNode = this.clientNodeProvider.clientNode();
        RenderJobStartRequest renderJobStartRequest = new RenderJobStartRequest();
        renderJobStartRequest.setUri(uri);
        renderJobStartRequest.setClientApp(clientNode.app());
        renderJobStartRequest.setClientNode(clientNode.node());
        Client2ControlRestClient client2ControlRestClientSelected = this.renderJobTest ? this.client2ControlRestClientOnlyForTest : this.client2ControlRestClient;
        RenderJobStartResponse renderJobStartResponse = client2ControlRestClientSelected.startRenderJob(renderJobStartRequest);
        if (renderJobStartResponse == null || !renderJobStartResponse.isSuccess() || renderJobStartResponse.getTaskId() == null) {
            throw new IllegalArgumentException("cannot start job render: " + JSONAccessor.impl().format((Object)renderJobStartResponse));
        }
        Long taskId = renderJobStartResponse.getTaskId();
        JobMeta jobMeta = renderJobStartResponse.getJobMeta();
        JobHint jobHint = renderJobStartResponse.getJobHint();
        RenderJobImpl renderJob = new RenderJobImpl(taskId, uri, jobMeta.isNfs(), jobMeta, jobHint, this.ioHubClientConfig, client2ControlRestClientSelected, clientNode, this.renderJobTest);
        return renderJob;
    }
}

