package com.ovopark.iohub.sdk.client.instream.test;

import com.ovopark.kernel.shared.Model;
import lombok.Data;
import org.springframework.web.multipart.MultipartFile;

/**
 * <pre>
 *    {
 *     "uri": "/iohub-test/import/importExcelWithSkipColumn",
 *     "importFileUrl":"C:\\Users\\Administrator\\Downloads\\设备录像报表(NVR)-skip.xlsx",
 *     "preDefParam":{
 *         "dataExistStrategy": "OVERRIDE"
 *     },
 *     "paramMap": {
 *         "startDate": "2024-11-20",
 *         "endDate": "2024-11-26",
 *         "organizeIds": "",
 *         "deviceMac": "",
 *         "deviceName": "",
 *         "recordDays": null,
 *         "deviceType": null,
 *         "name":"test"
 *     }
 * }
 *
 * }
 */
@Data
public class ImportTaskVo implements Model {

    private String uri;

    private String importFileUrl;

    private String dataExistStrategy;

    private String desc;

    private String params;

    private boolean test;

    private MultipartFile file;

}
