/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client.instream;

import com.ovopark.iohub.sdk.client.Client2ControlRestClient;
import com.ovopark.iohub.sdk.client.ClientNodeProvider;
import com.ovopark.iohub.sdk.client.ControlNode;
import com.ovopark.iohub.sdk.client.ControlNodeProxy;
import com.ovopark.iohub.sdk.client.IOHubClientActive;
import com.ovopark.iohub.sdk.client.IOHubClientConfig;
import com.ovopark.iohub.sdk.client.instream.ReadJob;
import com.ovopark.iohub.sdk.client.instream.ReadJobImpl;
import com.ovopark.iohub.sdk.client.instream.ReadJobManager;
import com.ovopark.iohub.sdk.model.JobMeta;
import com.ovopark.iohub.sdk.model.instream.ReadJobStartRequest;
import com.ovopark.iohub.sdk.model.instream.ReadJobStartResponse;
import com.ovopark.iohub.sdk.model.proto.internal.JobHint;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.vclient.ClientNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@IOHubClientActive
@Component
public class SpringReadJobFactory
implements ReadJobManager.ReadJobFactory,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(SpringReadJobFactory.class);
    final boolean renderJobTest = Config.ConfigPriority.option().getBoolean("iohub.client.renderJob.test", Boolean.valueOf(false));
    final String controlIp = "47.96.105.39";
    final int controlUiPort = 13900;
    private final Client2ControlRestClient client2ControlRestClientOnlyForTest = new Client2ControlRestClient(new ControlNode(){

        @Override
        public String ip() {
            return "47.96.105.39";
        }

        @Override
        public int port() {
            return this.uiPort();
        }

        @Override
        public int uiPort() {
            return 13900;
        }
    });
    @Autowired
    private ClientNodeProvider clientNodeProvider;
    @Autowired
    private IOHubClientConfig ioHubClientConfig;
    private Client2ControlRestClient client2ControlRestClient;

    @Autowired
    public void setControlNodeProxy(final ControlNodeProxy controlNodeProxy) {
        this.client2ControlRestClient = new Client2ControlRestClient(new ControlNode(){

            @Override
            public String ip() {
                return controlNodeProxy.ip();
            }

            @Override
            public int port() {
                return this.uiPort();
            }

            @Override
            public int uiPort() {
                return controlNodeProxy.uiPort();
            }
        });
    }

    public void run(String ... args) throws Exception {
        ReadJobManager.register((ReadJobManager.ReadJobFactory)this);
    }

    public ReadJob factory(String uri) {
        ClientNode clientNode = this.clientNodeProvider.clientNode();
        ReadJobStartRequest readJobStartRequest = new ReadJobStartRequest();
        readJobStartRequest.setUri(uri);
        readJobStartRequest.setClientApp(clientNode.app());
        readJobStartRequest.setClientNode(clientNode.node());
        Client2ControlRestClient client2ControlRestClientSelected = this.renderJobTest ? this.client2ControlRestClientOnlyForTest : this.client2ControlRestClient;
        ReadJobStartResponse readJobStartResponse = client2ControlRestClientSelected.startReadJob(readJobStartRequest);
        if (readJobStartResponse == null || !readJobStartResponse.isSuccess() || readJobStartResponse.getTaskId() == null) {
            throw new IllegalArgumentException("cannot start read job: " + JSONAccessor.impl().format((Object)readJobStartResponse));
        }
        Long taskId = readJobStartResponse.getTaskId();
        JobMeta jobMeta = readJobStartResponse.getJobMeta();
        JobHint jobHint = readJobStartResponse.getJobHint();
        ReadJobImpl readJob = new ReadJobImpl(taskId, uri, jobMeta.isNfs(), jobMeta, jobHint, this.ioHubClientConfig, client2ControlRestClientSelected, clientNode, this.renderJobTest);
        return readJob;
    }
}

