/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client.outstream;

import com.ovopark.iohub.sdk.client.Client2ControlTransport;
import com.ovopark.iohub.sdk.client.Client2WorkRestClient;
import com.ovopark.iohub.sdk.client.Client2WorkTransport;
import com.ovopark.iohub.sdk.client.IOHubClientConfig;
import com.ovopark.iohub.sdk.client.outstream.RenderJob;
import com.ovopark.iohub.sdk.model.AppNode;
import com.ovopark.iohub.sdk.model.JobMeta;
import com.ovopark.iohub.sdk.model.outstream.ExportPushCommitRequest;
import com.ovopark.iohub.sdk.model.outstream.ExportPushCommitResponse;
import com.ovopark.iohub.sdk.model.outstream.ExportPushDataRequest;
import com.ovopark.iohub.sdk.model.outstream.ExportPushDataResponse;
import com.ovopark.iohub.sdk.model.outstream.RenderJobAssignWorkRequest;
import com.ovopark.iohub.sdk.model.outstream.RenderJobAssignWorkResponse;
import com.ovopark.iohub.sdk.model.outstream.RenderJobHeartbeatRequest;
import com.ovopark.iohub.sdk.model.outstream.RenderJobHeartbeatResponse;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.iohub.sdk.model.proto.internal.HeaderImpl;
import com.ovopark.iohub.sdk.model.proto.internal.InMemoryOutStore;
import com.ovopark.iohub.sdk.model.proto.internal.JobHint;
import com.ovopark.iohub.sdk.model.proto.internal.NFSOutStore;
import com.ovopark.iohub.sdk.model.proto.internal.NFSSegmentModel;
import com.ovopark.iohub.sdk.model.proto.internal.RowTransLogConfig;
import com.ovopark.iohub.sdk.model.proto.internal.SegmentImpl;
import com.ovopark.iohub.sdk.model.proto.internal.TitleImpl;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.concurrent.ListenerFuture;
import com.ovopark.kernel.shared.kv.KVEngine;
import com.ovopark.kernel.shared.vclient.ClientNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

class RenderJobImpl
implements RenderJob {
    private static final Logger log = LoggerFactory.getLogger(RenderJobImpl.class);
    OutStore outStore;
    private final String uri;
    private final boolean nfs;
    final JobMeta jobMeta;
    final JobHint jobHint;
    private final IOHubClientConfig ioHubClientConfig;
    private final Client2ControlTransport client2ControlTransport;
    final ClientNode clientNode;
    final Long taskId;
    final boolean renderJobTest;
    private static final ScheduledExecutorService jobHeartbeatExecutor = new ScheduledThreadPoolExecutor(Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 8), Config.ConfigPriority.option().getInt("IOHUB_RENDER_JOB_HEARTBEAT_IO", Integer.valueOf(0))), Util.newThreadFactory((String)"iohub_render_job_heartbeat_io"), new ThreadPoolExecutor.AbortPolicy());
    private static final ExecutorService jobFutureExecutor = new ThreadPoolExecutor(Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 64), Config.ConfigPriority.option().getInt("IOHUB_RENDER_JOB_FUTURE_IO", Integer.valueOf(0))), Math.max(Math.max(Runtime.getRuntime().availableProcessors() * 2, 64), Config.ConfigPriority.option().getInt("IOHUB_RENDER_JOB_FUTURE_IO", Integer.valueOf(0))), 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), Util.newThreadFactory((String)"iohub_render_job_future_io"), new ThreadPoolExecutor.AbortPolicy());
    static final KVEngine.TtlFunc<String> renderFutureTtl = KVEngine.newTtl((String)RenderJob.class.getName());
    static final RestTemplate restTemplate;

    public RenderJobImpl(Long taskId, String uri, boolean nfs, JobMeta jobMeta, JobHint jobHint, IOHubClientConfig ioHubClientConfig, Client2ControlTransport client2ControlTransport, ClientNode clientNode, boolean renderJobTest) {
        this.taskId = taskId;
        this.uri = uri;
        this.nfs = nfs;
        this.jobMeta = jobMeta;
        this.jobHint = jobHint;
        this.ioHubClientConfig = ioHubClientConfig;
        this.client2ControlTransport = client2ControlTransport;
        this.clientNode = clientNode;
        this.renderJobTest = renderJobTest;
    }

    public synchronized OutStore outStore() {
        if (this.outStore == null) {
            if (this.nfs) {
                RowTransLogConfig rowTransLogConfig = new RowTransLogConfig();
                rowTransLogConfig.setRegionRowCount(1000);
                this.outStore = new NFSOutStore(this.ioHubClientConfig.nfsPath() + "/client-" + ClientNode.UUID_STR + "/render-job/" + this.taskId, 1, rowTransLogConfig);
                ((NFSOutStore)this.outStore).setLimitLogger(arg_0 -> ((Logger)log).info(arg_0));
            } else {
                this.outStore = new InMemoryOutStore(8);
                ((InMemoryOutStore)this.outStore).setLimitLogger(arg_0 -> ((Logger)log).info(arg_0));
            }
        }
        return this.outStore;
    }

    public RenderJob.RenderFuture render2Excel() {
        return this.render();
    }

    public RenderJob.RenderFuture render() {
        return this.render0(null);
    }

    private RenderFutureImpl render0(JobHint jobHint) {
        RenderJobAssignWorkRequest renderJobAssignWorkRequest = new RenderJobAssignWorkRequest();
        renderJobAssignWorkRequest.setTaskId(this.taskId.longValue());
        renderJobAssignWorkRequest.setClientApp(this.clientNode.app());
        renderJobAssignWorkRequest.setClientNode(this.clientNode.node());
        renderJobAssignWorkRequest.setUri(this.uri);
        renderJobAssignWorkRequest.setTest(this.renderJobTest);
        RenderJobAssignWorkResponse renderJobAssignWorkResponse = this.client2ControlTransport.assignWorkRenderJob(renderJobAssignWorkRequest);
        log.info("jobRenderAssignWorkResponse: " + JSONAccessor.impl().format((Object)renderJobAssignWorkResponse));
        if (renderJobAssignWorkResponse == null || !renderJobAssignWorkResponse.isSuccess() || renderJobAssignWorkResponse.getWorker() == null) {
            throw new IllegalArgumentException("cannot assign work for job render: " + JSONAccessor.impl().format((Object)renderJobAssignWorkResponse));
        }
        AppNode worker = renderJobAssignWorkResponse.getWorker();
        Client2WorkRestClient client2WorkTransport = new Client2WorkRestClient(worker, restTemplate);
        List sdList = this.outStore.sdList();
        if (this.outStore instanceof InMemoryOutStore) {
            ArrayList<SegmentImpl> list = new ArrayList<SegmentImpl>();
            for (Segment.SD sd : sdList) {
                Segment segment = this.outStore.segment(sd);
                list.add((SegmentImpl)segment);
            }
            ExportPushDataRequest exportPushDataRequest = new ExportPushDataRequest();
            exportPushDataRequest.setSegmentList(list);
            exportPushDataRequest.setTaskId(this.taskId.longValue());
            exportPushDataRequest.setApp(this.clientNode.app());
            exportPushDataRequest.setNode(this.clientNode.node());
            exportPushDataRequest.setWorkApp(worker.getApp());
            exportPushDataRequest.setWorkNode(worker.getNode());
            log.info("request push data checkpoint");
            ExportPushDataResponse exportPushDataResponse = client2WorkTransport.pushRenderJob(exportPushDataRequest);
            log.info("response push data checkpoint: " + JSONAccessor.impl().format((Object)exportPushDataResponse));
            if (exportPushDataResponse == null || !exportPushDataResponse.isSuccess()) {
                throw new IllegalStateException("cannot push data to worker:");
            }
            ExportPushCommitRequest exportPushCommitRequest = new ExportPushCommitRequest();
            exportPushCommitRequest.setFileName(((InMemoryOutStore)this.outStore).getFileName());
            exportPushCommitRequest.setTaskId(this.taskId.longValue());
            exportPushCommitRequest.setApp(this.clientNode.app());
            exportPushCommitRequest.setNode(this.clientNode.node());
            exportPushCommitRequest.setWorkApp(worker.getApp());
            exportPushCommitRequest.setWorkNode(worker.getNode());
            exportPushCommitRequest.setGroupMap(((InMemoryOutStore)this.outStore).getGroupMap());
            exportPushCommitRequest.setFeature(((InMemoryOutStore)this.outStore).getFeature());
            exportPushCommitRequest.setJobHint(jobHint);
            log.info("request commit checkpoint");
            ExportPushCommitResponse exportPushCommitResponse = client2WorkTransport.commitRenderJob(exportPushCommitRequest);
            log.info("response commit checkpoint: " + JSONAccessor.impl().format((Object)exportPushCommitResponse));
            if (exportPushCommitResponse == null || !exportPushCommitResponse.isSuccess()) {
                throw new IllegalStateException("cannot commit data to worker:");
            }
        } else {
            ExportPushDataRequest exportPushDataRequest = new ExportPushDataRequest();
            exportPushDataRequest.setTaskId(this.taskId.longValue());
            exportPushDataRequest.setApp(this.clientNode.app());
            exportPushDataRequest.setNode(this.clientNode.node());
            exportPushDataRequest.setWorkApp(worker.getApp());
            exportPushDataRequest.setWorkNode(worker.getNode());
            log.info("request push data checkpoint");
            ExportPushDataResponse exportPushDataResponse = client2WorkTransport.pushRenderJob(exportPushDataRequest);
            log.info("response push data checkpoint: " + JSONAccessor.impl().format((Object)exportPushDataResponse));
            if (exportPushDataResponse == null || !exportPushDataResponse.isSuccess()) {
                throw new IllegalStateException("cannot push data to worker:");
            }
            ArrayList<NFSSegmentModel> nfsSegmentModelList = new ArrayList<NFSSegmentModel>();
            for (Segment.SD sd : sdList) {
                NFSSegmentModel nfsSegmentModel = new NFSSegmentModel();
                nfsSegmentModel.setName(sd.getName());
                nfsSegmentModel.setUrl(sd.getUrl());
                nfsSegmentModel.setMeta(sd.getMeta());
                nfsSegmentModel.setRowCount(sd.getRowCount());
                Segment segment = this.outStore.segment(sd);
                nfsSegmentModel.setTitle((TitleImpl)segment.title());
                nfsSegmentModel.setHeader((HeaderImpl)segment.header());
                nfsSegmentModel.setGroup(segment.group());
                nfsSegmentModel.setFeature(segment.feature());
                nfsSegmentModelList.add(nfsSegmentModel);
            }
            ExportPushCommitRequest exportPushCommitRequest = new ExportPushCommitRequest();
            exportPushCommitRequest.setFileName(((NFSOutStore)this.outStore).getFileName());
            exportPushCommitRequest.setNfsSegmentModelList(nfsSegmentModelList);
            exportPushCommitRequest.setTaskId(this.taskId.longValue());
            exportPushCommitRequest.setApp(this.clientNode.app());
            exportPushCommitRequest.setNode(this.clientNode.node());
            exportPushCommitRequest.setWorkApp(worker.getApp());
            exportPushCommitRequest.setWorkNode(worker.getNode());
            exportPushCommitRequest.setGroupMap(((NFSOutStore)this.outStore).getGroupMap());
            exportPushCommitRequest.setFileIOUrl(((NFSOutStore)this.outStore).getFileIOUrl());
            exportPushCommitRequest.setFeature(((NFSOutStore)this.outStore).getFeature());
            exportPushCommitRequest.setJobHint(jobHint);
            log.info("request commit checkpoint");
            ExportPushCommitResponse exportPushCommitResponse = client2WorkTransport.commitRenderJob(exportPushCommitRequest);
            log.info("response commit checkpoint: " + JSONAccessor.impl().format((Object)exportPushCommitResponse));
            if (exportPushCommitResponse == null || !exportPushCommitResponse.isSuccess()) {
                log.error("cannot commit data to worker:" + JSONAccessor.impl().format((Object)exportPushCommitResponse));
                throw new IllegalStateException("cannot commit data to worker:");
            }
        }
        RenderFutureImpl renderFuture = new RenderFutureImpl();
        RenderFutureTask renderFutureTask = new RenderFutureTask(this.taskId, worker, this.clientNode, renderFuture);
        jobHeartbeatExecutor.schedule(Util.catchRunnable((Util.CatchRunnable)renderFutureTask), 5L, TimeUnit.SECONDS);
        renderFutureTtl.putIfAbsentAndGet((Comparable)((Object)String.valueOf(this.taskId)), k -> renderFutureTask, 900L, TimeUnit.SECONDS);
        return renderFuture;
    }

    public RenderJob.RenderFuture render4Test(JobHint jobHint) {
        return this.render0(jobHint);
    }

    static {
        renderFutureTtl.subscribeTtl(t -> true, (getResult, l, l1) -> {
            String key = (String)((Object)getResult.key());
            log.info("onExpired: " + key);
            RenderFutureImpl renderFuture = (RenderFutureImpl)getResult.value();
            renderFuture.setOutFileUrlAndNotify(null, new TimeoutException("seconds: " + TimeUnit.MILLISECONDS.toSeconds(l1)));
        });
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(45000);
        factory.setConnectTimeout(15000);
        restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }

    static class RenderFutureImpl
    implements RenderJob.RenderFuture {
        private final ListenerFuture.ListenerFutureSetter<String> futureSetter = ListenerFuture.newFuture();

        RenderFutureImpl() {
        }

        void setOutFileUrlAndNotify(String outFileUrl, Throwable t) {
            this.futureSetter.setValueAndNotify((Object)outFileUrl, t);
        }

        void cancelAndNotify() {
            this.futureSetter.cancelAndNotify();
        }

        public String get() throws InterruptedException, ExecutionException {
            return (String)this.futureSetter.get();
        }

        public String get(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
            return (String)this.futureSetter.get(timeout, timeUnit);
        }

        public boolean cancelled() {
            return this.futureSetter.isCancelled();
        }

        public void cancel() {
            this.futureSetter.cancel(true);
        }

        public void setRenderListener(RenderJob.RenderListener renderListener) {
            this.futureSetter.addListener((arg_0, arg_1) -> ((RenderJob.RenderListener)renderListener).onRender(arg_0, arg_1));
        }
    }

    static class RenderFutureTask
    implements Util.CatchRunnable {
        final Long taskId;
        final AppNode worker;
        final ClientNode clientNode;
        final RenderFutureImpl renderFuture;
        final long startMs = System.currentTimeMillis();
        final Client2WorkTransport client2WorkTransport;
        int failCount;

        public RenderFutureTask(Long taskId, AppNode worker, ClientNode clientNode, RenderFutureImpl renderFuture) {
            this.taskId = taskId;
            this.worker = worker;
            this.clientNode = clientNode;
            this.renderFuture = renderFuture;
            SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
            factory.setReadTimeout(45000);
            factory.setConnectTimeout(15000);
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
            restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
            this.client2WorkTransport = new Client2WorkRestClient(worker, restTemplate);
        }

        public void run() throws Exception {
            if (this.renderFuture.cancelled()) {
                log.info("cancel job render by client: " + this.taskId);
                return;
            }
            RenderJobHeartbeatRequest renderJobHeartbeatRequest = new RenderJobHeartbeatRequest();
            renderJobHeartbeatRequest.setTaskId(this.taskId.longValue());
            renderJobHeartbeatRequest.setClientApp(this.clientNode.app());
            renderJobHeartbeatRequest.setClientNode(this.clientNode.node());
            renderJobHeartbeatRequest.setWorkNode(this.worker.getNode());
            RenderJobHeartbeatResponse renderJobHeartbeatResponse = this.client2WorkTransport.heartbeatRenderJob(renderJobHeartbeatRequest);
            if (renderJobHeartbeatResponse == null || !renderJobHeartbeatResponse.isSuccess()) {
                log.info("response job render heartbeat: " + JSONAccessor.impl().format((Object)renderJobHeartbeatResponse));
            }
            if (renderJobHeartbeatResponse == null || !renderJobHeartbeatResponse.isSuccess()) {
                if (this.failCount++ > 5) {
                    renderFutureTtl.delete((Comparable)((Object)String.valueOf(this.taskId)));
                    this.renderFuture.setOutFileUrlAndNotify(null, new RuntimeException("render server error: " + (renderJobHeartbeatResponse == null ? "" : renderJobHeartbeatResponse.getDesc())));
                    return;
                }
                jobHeartbeatExecutor.schedule(Util.catchRunnable((Util.CatchRunnable)this), 5L, TimeUnit.SECONDS);
                return;
            }
            if (renderJobHeartbeatResponse.isRendering()) {
                jobHeartbeatExecutor.schedule(Util.catchRunnable((Util.CatchRunnable)this), 5L, TimeUnit.SECONDS);
                return;
            }
            if (renderJobHeartbeatResponse.isRenderCancelled()) {
                log.info("render job ( " + this.taskId + " ) was cancelled by work: " + JSONAccessor.impl().format((Object)renderJobHeartbeatResponse));
                renderFutureTtl.delete((Comparable)((Object)String.valueOf(this.taskId)));
                this.renderFuture.cancelAndNotify();
                return;
            }
            if (renderJobHeartbeatResponse.isRenderError()) {
                renderFutureTtl.delete((Comparable)((Object)String.valueOf(this.taskId)));
                this.renderFuture.setOutFileUrlAndNotify(null, new RuntimeException(renderJobHeartbeatResponse.getRenderErrorDesc()));
                return;
            }
            if (renderJobHeartbeatResponse.isRenderCompleted()) {
                renderFutureTtl.delete((Comparable)((Object)String.valueOf(this.taskId)));
                String outFileUrl = renderJobHeartbeatResponse.getOutFileUrl();
                this.renderFuture.setOutFileUrlAndNotify(outFileUrl, null);
                return;
            }
            throw new RuntimeException("unreachable code , error???");
        }
    }
}

