/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.IOHubClientActive;
import com.ovopark.kernel.shared.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class IOHubClientCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(IOHubClientCondition.class);

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean f = metadata.isAnnotated(IOHubClientActive.class.getName());
        if (!f) {
            return true;
        }
        String activeJobClient = context.getEnvironment().getProperty("IOHUB_JOB_CLIENT_ACTIVE");
        if (Util.isEmpty((CharSequence)activeJobClient)) {
            activeJobClient = context.getEnvironment().getProperty("IOHUB_CLIENT_ACTIVE");
        }
        if ("off".equalsIgnoreCase(activeJobClient)) {
            log.warn("[off] inactive bean class: " + metadata.toString());
            return false;
        }
        if (Util.isEmpty((CharSequence)activeJobClient)) {
            log.warn("[empty, as on] active bean class: " + metadata.toString());
            return true;
        }
        if (activeJobClient.equalsIgnoreCase("on") || activeJobClient.equalsIgnoreCase("true")) {
            log.warn("[on|true] active bean class: " + metadata.toString());
            return true;
        }
        return false;
    }
}

