package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.model.proto.ModuleUri;
import com.ovopark.iohub.sdk.model.proto.TaskCreatedRequest;
import com.ovopark.iohub.sdk.model.proto.Watermark;
import com.ovopark.iohub.sdk.model.proto.internal.TaskCreatedRequestImpl;
import com.ovopark.iohub.sdk.model.proto.internal.WatermarkModelImpl;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.BaseResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static com.ovopark.kernel.shared.Util.isEmpty;

@IOHubClientActive
@Component("com.ovopark.iohub.sdk.client.IOTaskServiceImpl")
@Slf4j
public class IOTaskServiceImpl implements IOTaskService {


    @Autowired
    Client2ControlTransport client2ControlTransport;


    @Override
    public BaseResult<?> watermarkSync(ModuleUri moduleUri, String sessionToken, Watermark.WatermarkModel watermarkModel) {

        if (isEmpty(((WatermarkModelImpl) watermarkModel).getExportName())) {
            throw new IllegalArgumentException("exportName is required");
        }
        TaskCreatedRequestImpl taskCreatedRequest=new TaskCreatedRequestImpl();
        taskCreatedRequest.setUri(moduleUri.getUri());
        taskCreatedRequest.setSessionToken(sessionToken);
        taskCreatedRequest.setParamMap(JSONAccessor.impl().read(JSONAccessor.impl().format(watermarkModel)));
        return client2ControlTransport.watermarkSync(taskCreatedRequest);
    }

    @Override
    public BaseResult<?> watermarkSync(ModuleUri moduleUri, String sessionToken
            ,String exportName,String file, String fileType, String waterConfigRef) {
        if (isEmpty(exportName)) {
            throw new IllegalArgumentException("exportName is required");
        }
        TaskCreatedRequest taskCreatedRequest = Watermark.get().open()
                .file(file, fileType)
                .waterConfigRef(waterConfigRef)
                .moduleUri(moduleUri)
                .sessionToken(sessionToken)
                .exportName(exportName)
                .build();
        return client2ControlTransport.watermarkSync(taskCreatedRequest);
    }

    @Override
    public BaseResult<?> watermarkSync(ModuleUri moduleUri, Integer groupId,Integer userId, String exportName,String url, String fileType, String waterConfigRef) {
        if (isEmpty(exportName)) {
            throw new IllegalArgumentException("exportName is required");
        }
        TaskCreatedRequest taskCreatedRequest = Watermark.get().open()
                .file(url, fileType)
                .waterConfigRef(waterConfigRef)
                .moduleUri(moduleUri)
                .groupId(groupId)
                .userId(userId)
                .exportName(exportName)
                .build();
        return client2ControlTransport.watermarkSync(taskCreatedRequest);
    }
}
