/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.Client2ControlTransport;
import com.ovopark.iohub.sdk.client.ControlNode;
import com.ovopark.iohub.sdk.model.ClientNodeRegisterRequest;
import com.ovopark.iohub.sdk.model.ClientNodeRegisterResponse;
import com.ovopark.iohub.sdk.model.PreFlowErrorRequest;
import com.ovopark.iohub.sdk.model.PreFlowErrorResponse;
import com.ovopark.iohub.sdk.model.TaskLockRequest;
import com.ovopark.iohub.sdk.model.TaskLockResponse;
import com.ovopark.iohub.sdk.model.instream.ReadJobAssignWorkRequest;
import com.ovopark.iohub.sdk.model.instream.ReadJobAssignWorkResponse;
import com.ovopark.iohub.sdk.model.instream.ReadJobStartRequest;
import com.ovopark.iohub.sdk.model.instream.ReadJobStartResponse;
import com.ovopark.iohub.sdk.model.outstream.RenderJobAssignWorkRequest;
import com.ovopark.iohub.sdk.model.outstream.RenderJobAssignWorkResponse;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartRequest;
import com.ovopark.iohub.sdk.model.outstream.RenderJobStartResponse;
import com.ovopark.iohub.sdk.model.proto.TaskCreatedRequest;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.vclient.Client2ServerTransport;
import com.ovopark.module.shared.BaseResult;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class Client2ControlRestClient
implements Client2ControlTransport {
    private static final Logger log = LoggerFactory.getLogger(Client2ControlRestClient.class);
    final boolean verbose = Config.ConfigPriority.option().getBoolean("iohub.client.io.verbose", Boolean.valueOf(true));
    private final RestTemplate restTemplate;
    private final ControlNode controlNode;

    public Client2ControlRestClient(ControlNode controlNode, RestTemplate restTemplate) {
        this.controlNode = controlNode;
        this.restTemplate = restTemplate;
    }

    public Client2ControlRestClient(ControlNode controlNode) {
        this.controlNode = controlNode;
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(45000);
        factory.setConnectTimeout(15000);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        this.restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }

    @Override
    public ClientNodeRegisterResponse heartbeat(ClientNodeRegisterRequest clientNodeRegisterRequest) {
        return this.rpc(clientNodeRegisterRequest, "/jobClient/heartbeat", ClientNodeRegisterResponse.class);
    }

    private <T> T rpc(Object request, String path, Class<T> clazz) {
        String url = "http://" + this.controlNode.ip() + ":" + this.controlNode.port() + "/iohub-control";
        url = url + path;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity formEntity = new HttpEntity((Object)JSONAccessor.impl().format(request), (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)formEntity, String.class, new Object[0]);
            int statusCodeValue = responseEntity.getStatusCodeValue();
            if (statusCodeValue == 200) {
                return (T)JSONAccessor.impl().read((String)responseEntity.getBody(), clazz);
            }
            return null;
        }
        catch (Exception e) {
            if (this.verbose) {
                log.error(e.getMessage());
            }
            return null;
        }
    }

    private <T> T restWithFile(Map<String, Object> params, String file, String path, Class<T> clazz) {
        String url = "http://" + this.controlNode.ip() + ":" + this.controlNode.port() + "/iohub-control";
        url = url + path;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "multipart/form-data");
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            multiValueMap.add((Object)entry.getKey(), entry.getValue());
        }
        multiValueMap.add((Object)"file", (Object)new FileSystemResource(file));
        HttpEntity formEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)formEntity, String.class, new Object[0]);
            int statusCodeValue = responseEntity.getStatusCodeValue();
            if (statusCodeValue == 200) {
                return (T)JSONAccessor.impl().read((String)responseEntity.getBody(), clazz);
            }
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    @Override
    public TaskLockResponse lockClient(TaskLockRequest taskLockRequest) {
        return this.rpc(taskLockRequest, "/jobClient/lockClient", TaskLockResponse.class);
    }

    public Client2ServerTransport.TaskLogResponse log(Client2ServerTransport.TaskLogRequest taskLogRequest) {
        return this.rpc(taskLogRequest, "/jobClient/log", Client2ServerTransport.TaskLogResponse.class);
    }

    @Override
    public PreFlowErrorResponse preFlowError(PreFlowErrorRequest preFlowErrorRequest) {
        return this.rpc(preFlowErrorRequest, "/jobClient/preFlowError", PreFlowErrorResponse.class);
    }

    @Override
    public RenderJobStartResponse startRenderJob(RenderJobStartRequest renderJobStartRequest) {
        return this.rpc(renderJobStartRequest, "/jobClient/renderJob/start", RenderJobStartResponse.class);
    }

    @Override
    public RenderJobAssignWorkResponse assignWorkRenderJob(RenderJobAssignWorkRequest renderJobAssignWorkRequest) {
        return this.rpc(renderJobAssignWorkRequest, "/jobClient/renderJob/assignWork", RenderJobAssignWorkResponse.class);
    }

    @Override
    public ReadJobStartResponse startReadJob(ReadJobStartRequest readJobStartRequest) {
        return this.rpc(readJobStartRequest, "/jobClient/readJob/start", ReadJobStartResponse.class);
    }

    @Override
    public ReadJobAssignWorkResponse assignWorkReadJob(ReadJobAssignWorkRequest readJobAssignWorkRequest) {
        return this.rpc(readJobAssignWorkRequest, "/jobClient/readJob/assignWork", ReadJobAssignWorkResponse.class);
    }

    @Override
    public BaseResult<?> watermarkSync(TaskCreatedRequest taskCreatedRequest) {
        return this.rpc(taskCreatedRequest, "/export/watermarkSync", BaseResult.class);
    }
}

