/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.client;

import com.ovopark.iohub.sdk.client.Client2ControlTransport;
import com.ovopark.iohub.sdk.client.IOHubClientActive;
import com.ovopark.iohub.sdk.client.IOTaskService;
import com.ovopark.iohub.sdk.model.proto.ModuleUri;
import com.ovopark.iohub.sdk.model.proto.TaskCreatedRequest;
import com.ovopark.iohub.sdk.model.proto.Watermark;
import com.ovopark.iohub.sdk.model.proto.internal.TaskCreatedRequestImpl;
import com.ovopark.iohub.sdk.model.proto.internal.WatermarkModelImpl;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.BaseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@IOHubClientActive
@Component(value="com.ovopark.iohub.sdk.client.IOTaskServiceImpl")
public class IOTaskServiceImpl
implements IOTaskService {
    private static final Logger log = LoggerFactory.getLogger(IOTaskServiceImpl.class);
    @Autowired
    Client2ControlTransport client2ControlTransport;

    @Override
    public BaseResult<?> watermarkSync(ModuleUri moduleUri, String sessionToken, Watermark.WatermarkModel watermarkModel) {
        if (Util.isEmpty((CharSequence)((WatermarkModelImpl)watermarkModel).getExportName())) {
            throw new IllegalArgumentException("exportName is required");
        }
        TaskCreatedRequestImpl taskCreatedRequest = new TaskCreatedRequestImpl();
        taskCreatedRequest.setUri(moduleUri.getUri());
        taskCreatedRequest.setSessionToken(sessionToken);
        taskCreatedRequest.setParamMap(JSONAccessor.impl().read(JSONAccessor.impl().format((Object)watermarkModel)));
        return this.client2ControlTransport.watermarkSync((TaskCreatedRequest)taskCreatedRequest);
    }

    @Override
    public BaseResult<?> watermarkSync(ModuleUri moduleUri, String sessionToken, String exportName, String file, String fileType, String waterConfigRef) {
        if (Util.isEmpty((CharSequence)exportName)) {
            throw new IllegalArgumentException("exportName is required");
        }
        TaskCreatedRequest taskCreatedRequest = Watermark.get().open().file(file, fileType).waterConfigRef(waterConfigRef).moduleUri(moduleUri).sessionToken(sessionToken).exportName(exportName).build();
        return this.client2ControlTransport.watermarkSync(taskCreatedRequest);
    }

    @Override
    public BaseResult<?> watermarkSync(ModuleUri moduleUri, Integer groupId, Integer userId, String exportName, String url, String fileType, String waterConfigRef) {
        if (Util.isEmpty((CharSequence)exportName)) {
            throw new IllegalArgumentException("exportName is required");
        }
        TaskCreatedRequest taskCreatedRequest = Watermark.get().open().file(url, fileType).waterConfigRef(waterConfigRef).moduleUri(moduleUri).groupId(groupId).userId(userId).exportName(exportName).build();
        return this.client2ControlTransport.watermarkSync(taskCreatedRequest);
    }
}

