package com.ovopark.iohub.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ovopark.iohub.sdk.model.proto.internal.JobHint;
import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.util.concurrent.atomic.AtomicInteger;

@Data
public class TaskModel implements Model {

    private String uri;

    private long jobTaskId;

    private Integer exportTaskId;

    private Integer importTaskId;

    private boolean export;

    private Integer userId;

    private String userName;

    private Integer userGroupId;

    private String session;

    private String workNode;

    private String workApp;

    private String clientNode;

    private String clientApp;

    private long acceptTime;

    private String acceptTimeStr;

    private String ioThreadName;

    @JsonIgnore
    transient TransientFunc transientFunc;

    private ExportClientStat exportClientStat;

    private ExportWorkStat exportWorkStat;

    private ImportClientStat importClientStat;

    private ImportWorkStat importWorkStat;

    /**
     * @since 5.2
     */
    private JobMeta jobMeta;

    /**
     * @since 5.2
     */
    private JobHint jobHint;

    @Data
    public static class ExportClientStat implements Model{

        private int segmentCount;

        private String currentSegment;

        private int sumRowCount;

        private int rowCountAdded;

        private String lastIoTimeStr;

        private long byteSize;

        private String args;

        private String argsMd5;

        private String convertArgs;

        private long jsonByteSize;

        private long compressedByteSize;

        private long maxRowRegionByteSize;

    }

    @Data
    public static class ExportWorkStat implements Model{


        private String renderFuture;

        private String args;

        private String argsMd5;

        private String exportJson;

        /**
         * @since 6.22
         */
        private int completedRenderRowCount;

        public void incrementCompletedRenderRowCount(){
            completedRenderRowCount++;
        }

    }


    @Data
    public static class ImportClientStat implements Model{

        private int maxRowCount;

        private int segmentCount;

        private String currentSegment;

        private int sumRowCount;

        private int rowCountAdded;

        private boolean resetStream;

    }


    @Data
    public static class ImportWorkStat implements Model{

        private int sumRowCount;

        private int segmentCount;

        private String currentSegment;

        private boolean readCompleted;

        private String fileUrl;

        private String errorFileUrl;

        private String readFuture;

        private String renderFuture;


    }

}
