package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.model.*;
import lombok.Data;

public interface JobService {


    JobCreateResponse jobCreate(JobCreateRequest jobCreateRequest);

    TaskCreateResponse taskCreate(TaskCreateRequest taskCreateRequest);

    TaskUpdateResponse taskUpdate(TaskUpdateRequest taskUpdateRequest);

    TaskLogResponse taskLog(TaskLogRequest taskLogRequest);

    TaskGetResponse taskGet(TaskGetRequest taskGetRequest);

    TaskMetaGetResponse taskMetaGet(TaskMetaGetRequest taskMetaGetRequest);


    void doOnceOnDevice(Integer deviceStatusId, Integer deviceId, Integer userId, Integer group
            , String type, String jsonStr, String desc, String jobId, TaskListener taskListener);

    <T> T doOnceOnDevice(Integer deviceStatusId, Integer deviceId, Integer userId, Integer group
            , String type, String jsonStr, String desc, String jobId, TaskCallListener<T> taskCallListener);

    Long cronTaskRegister(String name, String bean, String cron);

    Long delayTaskRegister(String name, String bean, String args, long triggerTimeMs, long endTimeMs, int triggerIfMiss, Integer createBy);


    boolean register(String jobType,String beanUrl,String group, Long minVer);

    boolean register(String jobType, String beanUrl, String group, Long minVer, TaskListenerRunnerProviderConfig taskListenerRunnerProviderConfig);

    interface TaskListener{

        void on(TaskContext taskContext);

    }

    interface TaskCallListener<T>{

        T on(TaskContext taskContext);

    }


    interface TaskContext extends com.ovopark.kernel.shared.job.TaskContext {

        void status(JobStatus jobStatus);

        void completedDesc(String completedDesc);

        void appendLog(String content);

        TaskGetResponse.Task task();

    }

    interface TaskListenerRunnerProvider {

        String name();

        boolean start(String jobType, String beanUrl, String group, Long minVer, TaskListener taskListener
                   , JobService jobService,
                      TaskListenerRunnerProviderConfig taskListenerRunnerProviderConfig);

        void close();

    }

    @Data
    class TaskListenerRunnerProviderConfig{

        int concurrency;

        String provider;

        private String offsetReset ;

    }

}
